/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.accents.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.obscuria.accents.content.item.VanityItem;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public abstract class VanityRenderer
extends GeoArmorRenderer<VanityItem> {
    public VanityRenderer(GeoModel<VanityItem> model) {
        super(model);
        this.addRenderLayer(new OverlayLayer(this, false));
    }

    public VanityRenderer(GeoModel<VanityItem> model, boolean glowing) {
        super(model);
        this.addRenderLayer(new OverlayLayer(this, glowing));
    }

    public ItemStack stack() {
        return this.currentStack;
    }

    public static final class OverlayLayer
    extends GeoRenderLayer<VanityItem> {
        private final VanityRenderer vanity;
        private final ResourceLocation texture;
        private final boolean glowing;

        public OverlayLayer(VanityRenderer renderer, boolean glowing) {
            super((GeoRenderer)renderer);
            this.texture = this.getTextureResource((GeoAnimatable)((VanityItem)renderer.getAnimatable())).m_247266_(this::pathToOverlay);
            this.vanity = renderer;
            this.glowing = glowing;
        }

        public void render(PoseStack poseStack, VanityItem animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
            RenderType overlayRenderType = this.getRenderType(animatable, bufferSource, partialTick);
            int light = this.glowing ? 0xF000F0 : packedLight;
            int color = animatable.m_41121_(this.vanity.stack());
            float r = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
            float g = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
            float b = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
            this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)animatable, overlayRenderType, bufferSource.m_6299_(overlayRenderType), partialTick, light, OverlayTexture.f_118083_, r, g, b, 1.0f);
        }

        private RenderType getRenderType(VanityItem animatable, MultiBufferSource bufferSource, float partialTick) {
            return this.glowing ? RenderType.m_110488_((ResourceLocation)this.texture) : this.renderer.getRenderType((GeoAnimatable)animatable, this.texture, bufferSource, partialTick);
        }

        private String pathToOverlay(String path) {
            return path.replace(".png", "_overlay.png");
        }
    }
}

