/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.accents.content.inventory;

import com.google.common.collect.Lists;
import dev.obscuria.accents.content.recipe.SewingRecipe;
import dev.obscuria.accents.content.registry.AccentsBlocks;
import dev.obscuria.accents.content.registry.AccentsMenus;
import dev.obscuria.accents.content.registry.AccentsRecipes;
import java.util.List;
import lombok.Generated;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public final class SewingMenu
extends AbstractContainerMenu {
    public static final int INPUT_SLOT = 0;
    public static final int RESULT_SLOT = 1;
    public final Container container;
    private final ContainerLevelAccess access;
    private final DataSlot selectedRecipeIndex = DataSlot.m_39401_();
    private final Level level;
    private final Slot inputSlot;
    private final Slot resultSlot;
    private final ResultContainer resultContainer;
    private List<SewingRecipe> recipes = Lists.newArrayList();
    private Runnable slotUpdateListener;
    private long lastSoundTime;
    private ItemStack input = ItemStack.f_41583_;

    public SewingMenu(int containerId, Inventory inventory) {
        this(containerId, inventory, ContainerLevelAccess.f_39287_);
    }

    public SewingMenu(int containerId, Inventory inventory, final ContainerLevelAccess access) {
        super(AccentsMenus.SEWING_STATION, containerId);
        this.slotUpdateListener = () -> {};
        this.container = new SimpleContainer(1){

            public void m_6596_() {
                super.m_6596_();
                SewingMenu.this.m_6199_((Container)this);
                SewingMenu.this.slotUpdateListener.run();
            }
        };
        this.resultContainer = new ResultContainer();
        this.access = access;
        this.level = inventory.f_35978_.m_9236_();
        this.inputSlot = this.m_38897_(new Slot(this.container, 0, 20, 33));
        this.resultSlot = this.m_38897_(new Slot((Container)this.resultContainer, 1, 143, 33){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                stack.m_41678_(player.m_9236_(), player, stack.m_41613_());
                SewingMenu.this.resultContainer.m_58395_(player, this.getRelevantItems());
                ItemStack itemstack = SewingMenu.this.inputSlot.m_6201_(1);
                if (!itemstack.m_41619_()) {
                    SewingMenu.this.setupResultSlot();
                }
                access.m_39292_((level, pos) -> {
                    long gameTime = level.m_46467_();
                    if (SewingMenu.this.lastSoundTime != gameTime) {
                        level.m_5594_(null, pos, SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        SewingMenu.this.lastSoundTime = gameTime;
                    }
                });
                super.m_142406_(player, stack);
            }

            private List<ItemStack> getRelevantItems() {
                return List.of(SewingMenu.this.inputSlot.m_7993_());
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)inventory, k, 8 + k * 18, 142));
        }
        this.m_38895_(this.selectedRecipeIndex);
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.m_6501_();
    }

    public int getNumRecipes() {
        return this.recipes.size();
    }

    public boolean hasInputItem() {
        return this.inputSlot.m_6657_() && !this.recipes.isEmpty();
    }

    public boolean m_6875_(Player player) {
        return SewingMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)AccentsBlocks.SEWING_STATION.get()));
    }

    public boolean m_6366_(Player player, int id) {
        if (this.isValidRecipeIndex(id)) {
            this.selectedRecipeIndex.m_6422_(id);
            this.setupResultSlot();
        }
        return true;
    }

    public void m_6199_(Container inventory) {
        ItemStack stack = this.inputSlot.m_7993_();
        if (!stack.m_150930_(this.input.m_41720_())) {
            this.input = stack.m_41777_();
            this.setupRecipeList(inventory, stack);
        }
    }

    public MenuType<?> m_6772_() {
        return AccentsMenus.SEWING_STATION;
    }

    public void registerUpdateListener(Runnable listener) {
        this.slotUpdateListener = listener;
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.resultContainer && super.m_5882_(stack, slot);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack result = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            Item item = stack.m_41720_();
            result = stack.m_41777_();
            if (index == 1) {
                item.m_7836_(stack, player.m_9236_(), player);
                if (!this.m_38903_(stack, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(stack, result);
            } else if (index == 0 ? !this.m_38903_(stack, 2, 38, false) : (this.level.m_7465_().m_44015_((RecipeType)AccentsRecipes.SEWING.get(), (Container)new SimpleContainer(new ItemStack[]{stack}), this.level).isPresent() ? !this.m_38903_(stack, 0, 1, false) : (index >= 2 && index < 29 ? !this.m_38903_(stack, 29, 38, false) : index >= 29 && index < 38 && !this.m_38903_(stack, 2, 29, false)))) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (stack.m_41613_() == result.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stack);
            this.m_38946_();
        }
        return result;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.resultContainer.m_8016_(1);
        this.access.m_39292_((level, pos) -> this.m_150411_(player, this.container));
    }

    private boolean isValidRecipeIndex(int recipeIndex) {
        return recipeIndex >= 0 && recipeIndex < this.recipes.size();
    }

    private void setupRecipeList(Container container, ItemStack stack) {
        this.recipes.clear();
        this.selectedRecipeIndex.m_6422_(-1);
        this.resultSlot.m_5852_(ItemStack.f_41583_);
        if (!stack.m_41619_()) {
            this.recipes = this.level.m_7465_().m_44056_((RecipeType)AccentsRecipes.SEWING.get(), container, this.level);
        }
    }

    private void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.m_6501_())) {
            SewingRecipe recipe = this.recipes.get(this.selectedRecipeIndex.m_6501_());
            ItemStack stack = recipe.m_5874_(this.container, this.level.m_9598_());
            if (stack.m_246617_(this.level.m_246046_())) {
                this.resultContainer.m_6029_((Recipe)recipe);
                this.resultSlot.m_5852_(stack);
            } else {
                this.resultSlot.m_5852_(ItemStack.f_41583_);
            }
        } else {
            this.resultSlot.m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    @Generated
    public List<SewingRecipe> getRecipes() {
        return this.recipes;
    }
}

