/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.accents.content.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import dev.obscuria.accents.client.renderer.VanityRenderer;
import dev.obscuria.accents.content.Vanity;
import dev.obscuria.fragmentum.world.tooltip.TooltipOptions;
import dev.obscuria.fragmentum.world.tooltip.Tooltips;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class VanityItem
extends ArmorItem
implements GeoItem,
DyeableLeatherItem {
    private static final TooltipOptions FLAVOR = TooltipOptions.builder().withDefaultStyle(Style.f_131099_.m_131140_(ChatFormatting.GOLD).m_131155_(Boolean.valueOf(true))).withMaxLineLength(32).build();
    protected static final String VANITY_MODIFIER = "vanity_modifier";
    protected final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected final Vanity vanity;

    public VanityItem(Vanity vanity, Item.Properties properties) {
        super(vanity.material(), vanity.type(), properties);
        this.vanity = vanity;
    }

    public void appendModifiers(UUID uuid, BiConsumer<Attribute, AttributeModifier> consumer) {
        this.vanity.appendModifiers(uuid, consumer);
    }

    public VanityRenderer createVanityRenderer() {
        return this.vanity.createRenderer();
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        MutableComponent component = Component.m_237115_((String)(stack.m_41778_() + ".desc"));
        tooltip.addAll(Tooltips.process((Component)component, (Object)((Object)this), (TooltipOptions)FLAVOR));
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        if (slot != this.m_40402_()) {
            return super.m_7167_(slot);
        }
        UUID uuid = UUID.nameUUIDFromBytes(((Object)((Object)this)).getClass().getName().getBytes());
        HashMultimap modifiers = HashMultimap.create();
        this.vanity.appendModifiers(uuid, (x$0, x$1) -> modifiers.put(x$0, x$1));
        return modifiers;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, 20, state -> {
            state.setAnimation(DefaultAnimations.IDLE);
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

