/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.forge.service;

import dev.obscuria.fragmentum.config.AnnotationConfigBuilder;
import dev.obscuria.fragmentum.config.ConfigBuilder;
import dev.obscuria.fragmentum.config.ConfigLayout;
import dev.obscuria.fragmentum.forge.ForgeFragmentum;
import dev.obscuria.fragmentum.service.ConfigService;
import java.util.function.Consumer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public final class ForgeConfigService
implements ConfigService {
    public static final ForgeConfigService INSTANCE = new ForgeConfigService();

    private ForgeConfigService() {
    }

    @Override
    public void registerClient(String modId, ConfigBuilder builder) {
        this.registerInternal(modId, builder, ModConfig.Type.CLIENT);
    }

    @Override
    public void registerCommon(String modId, ConfigBuilder builder) {
        this.registerInternal(modId, builder, ModConfig.Type.COMMON);
    }

    @Override
    public void registerServer(String modId, ConfigBuilder builder) {
        this.registerInternal(modId, builder, ModConfig.Type.SERVER);
    }

    private void registerInternal(String modId, ConfigBuilder builder, ModConfig.Type type) {
        ForgeConfigSpec spec = builder.specBuilder.build();
        if (builder.fileName == null) {
            ModLoadingContext.get().registerConfig(type, (IConfigSpec)spec);
        } else {
            ModLoadingContext.get().registerConfig(type, (IConfigSpec)spec, builder.fileName);
        }
    }

    @Override
    public <T extends ConfigLayout> void registerClient(String modId, T layout, Consumer<T> listener) {
        AnnotationConfigBuilder.Instance instance = AnnotationConfigBuilder.build(layout);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, instance.spec());
        ForgeFragmentum.addListener(modId, event -> instance.maybeUpdate(event.getConfig(), layout, listener));
    }

    @Override
    public <T extends ConfigLayout> void registerClient(String modId, String fileName, T layout, Consumer<T> listener) {
        AnnotationConfigBuilder.Instance instance = AnnotationConfigBuilder.build(layout);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, instance.spec(), fileName);
        ForgeFragmentum.addListener(modId, event -> instance.maybeUpdate(event.getConfig(), layout, listener));
    }

    @Override
    public <T extends ConfigLayout> void registerCommon(String modId, T layout, Consumer<T> listener) {
        AnnotationConfigBuilder.Instance instance = AnnotationConfigBuilder.build(layout);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, instance.spec());
        ForgeFragmentum.addListener(modId, event -> instance.maybeUpdate(event.getConfig(), layout, listener));
    }

    @Override
    public <T extends ConfigLayout> void registerCommon(String modId, String fileName, T layout, Consumer<T> listener) {
        AnnotationConfigBuilder.Instance instance = AnnotationConfigBuilder.build(layout);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, instance.spec(), fileName);
        ForgeFragmentum.addListener(modId, event -> instance.maybeUpdate(event.getConfig(), layout, listener));
    }

    @Override
    public <T extends ConfigLayout> void registerServer(String modId, T layout, Consumer<T> listener) {
        AnnotationConfigBuilder.Instance instance = AnnotationConfigBuilder.build(layout);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, instance.spec());
        ForgeFragmentum.addListener(modId, event -> instance.maybeUpdate(event.getConfig(), layout, listener));
    }

    @Override
    public <T extends ConfigLayout> void registerServer(String modId, String fileName, T layout, Consumer<T> listener) {
        AnnotationConfigBuilder.Instance instance = AnnotationConfigBuilder.build(layout);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, instance.spec(), fileName);
        ForgeFragmentum.addListener(modId, event -> instance.maybeUpdate(event.getConfig(), layout, listener));
    }
}

