/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.accents.content;

import dev.obscuria.accents.client.renderer.VanityRenderer;
import dev.obscuria.accents.config.CommonConfig;
import dev.obscuria.fragmentum.config.ConfigValue;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1741;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public record Vanity(class_1738.class_8051 type, class_1741 material, ConfigValue<List<? extends String>> modifiers, Supplier<Supplier<VanityRenderer>> renderer, boolean isTrinket) {
    private static final String TEMPLATE_SEPARATOR = " ";
    private static final String MODIFIER_SEPARATOR = ":";
    private static final String ADDITION = "addition";

    public static Builder simple(class_1738.class_8051 type) {
        return new Builder(type, false);
    }

    public static Builder trinket(class_1738.class_8051 type) {
        return new Builder(type, true);
    }

    public void appendModifiers(UUID uuid, BiConsumer<class_1320, class_1322> consumer) {
        if (!((Boolean)CommonConfig.MODIFIERS_ENABLED.get()).booleanValue()) {
            return;
        }
        for (String template : (List)this.modifiers.get()) {
            class_1322 modifier;
            class_1320 attribute;
            String[] parts = template.split(TEMPLATE_SEPARATOR);
            if (parts.length != 2 || (attribute = this.parseAttribute(parts[0])) == null || (modifier = this.parseModifier(parts[1], uuid)) == null) continue;
            consumer.accept(attribute, modifier);
        }
    }

    public VanityRenderer createRenderer() {
        return this.renderer.get().get();
    }

    @Nullable
    private class_1320 parseAttribute(String input) {
        class_2960 id = class_2960.method_12829((String)input);
        return id == null ? null : (class_1320)class_7923.field_41190.method_10223(id);
    }

    @Nullable
    private class_1322 parseModifier(String input, UUID uuid) {
        String[] parts = input.split(MODIFIER_SEPARATOR);
        if (parts.length != 2) {
            return null;
        }
        try {
            class_1322.class_1323 operation = parts[0].equals(ADDITION) ? class_1322.class_1323.field_6328 : class_1322.class_1323.field_6330;
            double value = Double.parseDouble(parts[1]);
            return new class_1322(uuid, "vanity_modifier", value, operation);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static final class Builder {
        private final class_1738.class_8051 type;
        private final boolean isTrinket;
        @Nullable
        private ConfigValue<List<? extends String>> modifiers;
        private class_1741 material = class_1740.field_7897;

        private Builder(class_1738.class_8051 type, boolean isTrinket) {
            this.type = type;
            this.isTrinket = isTrinket;
        }

        public Builder material(class_1741 material) {
            this.material = material;
            return this;
        }

        public Builder modifiers(ConfigValue<List<? extends String>> source) {
            this.modifiers = source;
            return this;
        }

        public Vanity build(Supplier<Supplier<VanityRenderer>> renderer) {
            Objects.requireNonNull(this.modifiers, "Vanity modifiers must be set");
            return new Vanity(this.type, this.material, this.modifiers, renderer, this.isTrinket);
        }
    }
}

