/*
 * Decompiled with CFR 0.152.
 */
package net.meowratic_works.fsa;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.meowratic_works.fsa.init.FsaModEntities;
import net.meowratic_works.fsa.init.FsaModItems;
import net.meowratic_works.fsa.init.FsaModMenus;
import net.meowratic_works.fsa.init.FsaModParticleTypes;
import net.meowratic_works.fsa.init.FsaModSounds;
import net.meowratic_works.fsa.init.FsaModTabs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="fsa")
public class FsaMod {
    public static final Logger LOGGER = LogManager.getLogger(FsaMod.class);
    public static final String MODID = "fsa";
    private static boolean networkingRegistered = false;
    private static final Map<CustomPacketPayload.Type<?>, NetworkMessage<?>> MESSAGES = new HashMap();
    private static final Collection<Tuple<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<Tuple<Runnable, Integer>>();

    public FsaMod(IEventBus modEventBus) {
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::registerNetworking);
        FsaModSounds.REGISTRY.register(modEventBus);
        FsaModItems.REGISTRY.register(modEventBus);
        FsaModEntities.REGISTRY.register(modEventBus);
        FsaModTabs.REGISTRY.register(modEventBus);
        FsaModMenus.REGISTRY.register(modEventBus);
        FsaModParticleTypes.REGISTRY.register(modEventBus);
    }

    public static <T extends CustomPacketPayload> void addNetworkMessage(CustomPacketPayload.Type<T> id, StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
        if (networkingRegistered) {
            throw new IllegalStateException("Cannot register new network messages after networking has been registered");
        }
        MESSAGES.put(id, new NetworkMessage<T>(reader, handler));
    }

    private void registerNetworking(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID);
        MESSAGES.forEach((id, networkMessage) -> registrar.playBidirectional(id, networkMessage.reader(), networkMessage.handler()));
        networkingRegistered = true;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add((Tuple<Runnable, Integer>)new Tuple((Object)action, (Object)tick));
        }
    }

    @SubscribeEvent
    public void tick(ServerTickEvent.Post event) {
        ArrayList actions = new ArrayList();
        workQueue.forEach(work -> {
            work.setB((Object)((Integer)work.getB() - 1));
            if ((Integer)work.getB() == 0) {
                actions.add(work);
            }
        });
        actions.forEach(e -> ((Runnable)e.getA()).run());
        workQueue.removeAll(actions);
    }

    private record NetworkMessage<T extends CustomPacketPayload>(StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
    }

    @EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
    public static class GuiSyncInit {
        @SubscribeEvent
        public static void init(FMLCommonSetupEvent event) {
            FsaMod.addNetworkMessage(GuiSyncMessage.TYPE, GuiSyncMessage.STREAM_CODEC, GuiSyncMessage::handleData);
        }
    }

    public record GuiSyncMessage(String editbox, String value) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<GuiSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"fsa", (String)"gui_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, GuiSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            GuiSyncMessage.writeComponent(buffer, (Component)Component.literal((String)message.editbox));
            GuiSyncMessage.writeComponent(buffer, (Component)Component.literal((String)message.value));
        }, buffer -> {
            String editbox = GuiSyncMessage.readComponent(buffer).getString();
            String value = GuiSyncMessage.readComponent(buffer).getString();
            return new GuiSyncMessage(editbox, value);
        });

        public CustomPacketPayload.Type<GuiSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(GuiSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND) {
                context.enqueueWork(() -> {
                    Screen currentScreen = Minecraft.getInstance().screen;
                    HashMap<String, EditBox> textFieldsMap = new HashMap<String, EditBox>();
                    if (currentScreen != null) {
                        Field[] fields;
                        for (Field field : fields = currentScreen.getClass().getDeclaredFields()) {
                            if (!EditBox.class.isAssignableFrom(field.getType())) continue;
                            try {
                                field.setAccessible(true);
                                EditBox textField = (EditBox)field.get(currentScreen);
                                if (textField == null) continue;
                                textFieldsMap.put(field.getName(), textField);
                            }
                            catch (IllegalAccessException ex) {
                                StringWriter sw = new StringWriter();
                                PrintWriter pw = new PrintWriter(sw);
                                ex.printStackTrace(pw);
                                String exceptionAsString = sw.toString();
                                LOGGER.error(exceptionAsString);
                            }
                        }
                    }
                    if (textFieldsMap.get(message.editbox) != null) {
                        ((EditBox)textFieldsMap.get(message.editbox)).setValue(message.value);
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }

        private static Component readComponent(RegistryFriendlyByteBuf buffer) {
            return (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode((Object)buffer);
        }

        private static void writeComponent(RegistryFriendlyByteBuf buffer, Component component) {
            ComponentSerialization.TRUSTED_STREAM_CODEC.encode((Object)buffer, (Object)component);
        }
    }
}

