/*
 * Decompiled with CFR 0.152.
 */
package net.meowratic_works.fsa.client.sound;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.util.ClientUtil;

public class CustomAutoSoundKeyframeHandler<A extends GeoAnimatable>
implements AnimationController.SoundKeyframeHandler<A> {
    public void handle(SoundKeyframeEvent<A> event) {
        float pitch;
        ResourceLocation id;
        Level level = ClientUtil.getLevel();
        if (level == null) {
            return;
        }
        String raw = event.getKeyframeData().getSound();
        if (raw == null || raw.isEmpty()) {
            return;
        }
        String[] parts = raw.split("\\|");
        try {
            id = (ResourceLocation)ResourceLocation.read((String)parts[0]).getOrThrow();
        }
        catch (Exception e) {
            return;
        }
        SoundEvent sound = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(id);
        if (sound == null) {
            return;
        }
        GeoAnimatable animatable = event.getAnimatable();
        Vec3 pos = null;
        Entity entity = null;
        if (animatable instanceof Entity) {
            Entity e;
            entity = e = (Entity)animatable;
            pos = e.position();
        } else if (animatable instanceof BlockEntity) {
            BlockEntity be = (BlockEntity)animatable;
            pos = be.getBlockPos().getCenter();
        }
        if (pos == null) {
            return;
        }
        float volume = parts.length > 1 ? CustomAutoSoundKeyframeHandler.parse(parts[1], 1.0f) : 1.0f;
        float f = pitch = parts.length > 2 ? CustomAutoSoundKeyframeHandler.parse(parts[2], 1.0f) : 1.0f;
        SoundSource source = entity == null ? SoundSource.BLOCKS : (entity instanceof Enemy ? SoundSource.HOSTILE : SoundSource.NEUTRAL);
        level.playLocalSound(pos.x, pos.y, pos.z, sound, source, volume, pitch, false);
    }

    private static float parse(String s, float def) {
        try {
            return Float.parseFloat(s);
        }
        catch (Exception e) {
            return def;
        }
    }
}

