/*
 * Decompiled with CFR 0.152.
 */
package net.meowratic_works.fsa.entity;

import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.meowratic_works.fsa.init.FsaModEntities;
import net.meowratic_works.fsa.init.FsaModItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class Bullet02Entity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)FsaModItems.TRACER.get());
    private int knockback = 0;

    public Bullet02Entity(EntityType<? extends Bullet02Entity> type, Level world) {
        super(type, world);
    }

    public Bullet02Entity(EntityType<? extends Bullet02Entity> type, double x, double y, double z, Level world, @Nullable ItemStack firedFromWeapon) {
        super(type, x, y, z, world, PROJECTILE_ITEM, firedFromWeapon);
    }

    public Bullet02Entity(EntityType<? extends Bullet02Entity> type, LivingEntity entity, Level world, @Nullable ItemStack firedFromWeapon) {
        super(type, entity, world, PROJECTILE_ITEM, firedFromWeapon);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItem() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)FsaModItems.TRACER.get());
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        super.doPostHurtEffects(entity);
        entity.setArrowCount(entity.getArrowCount() - 1);
    }

    public void setKnockback(int knockback) {
        this.knockback = knockback;
    }

    public float getDmg() {
        return 0.0f;
    }

    protected void doKnockback(LivingEntity livingEntity, DamageSource damageSource) {
        if ((double)this.knockback > 0.0) {
            double d1 = Math.max(0.0, 1.0 - livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            Vec3 vec3 = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale((double)this.knockback * 0.6 * d1);
            if (vec3.lengthSqr() > 0.0) {
                livingEntity.push(vec3.x, 0.1, vec3.z);
            }
        }
    }

    public void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        Entity entity = entityHitResult.getEntity();
        Level level = this.level();
        level.explode((Entity)this, new DamageSource(level.holderOrThrow(DamageTypes.EXPLOSION)), null, this.getX(), this.getY(), this.getZ(), 3.0f, false, Level.ExplosionInteraction.BLOCK);
        entity.invulnerableTime = 0;
        entity.hurt(new DamageSource(entity.level().holderOrThrow(DamageTypes.GENERIC)), this.getDmg());
        this.discard();
    }

    public void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        Level level = this.level();
        level.explode((Entity)this, new DamageSource(level.holderOrThrow(DamageTypes.EXPLOSION)), null, this.getX(), this.getY(), this.getZ(), 3.0f, false, Level.ExplosionInteraction.BLOCK);
        Vec3 _center = new Vec3(this.getX(), this.getY(), this.getZ());
        List<Entity> _entfound = level.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(3.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList();
        for (Entity entityiterator : _entfound) {
            entityiterator.hurt(new DamageSource(level.holderOrThrow(DamageTypes.EXPLOSION)), this.getDmg() / 2.0f);
        }
        this.discard();
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel _level = (ServerLevel)level;
            _level.sendParticles((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY(), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        for (int time = 70; time > 0; --time) {
            if (time <= 0) {
                this.setNoGravity(true);
                continue;
            }
            this.setNoGravity(false);
        }
        if (this.inGround) {
            this.discard();
        }
    }

    public static Bullet02Entity shoot(Level world, LivingEntity entity, RandomSource source) {
        return Bullet02Entity.shoot(world, entity, source, 9.0f, 5.4, 0);
    }

    public static Bullet02Entity shoot(Level world, LivingEntity entity, RandomSource source, float pullingPower) {
        return Bullet02Entity.shoot(world, entity, source, pullingPower * 9.0f, 5.4, 0);
    }

    public static Bullet02Entity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        Bullet02Entity entityarrow = new Bullet02Entity((EntityType<? extends Bullet02Entity>)((EntityType)FsaModEntities.BULLET_02.get()), entity, world, null);
        entityarrow.shoot(entity.getViewVector((float)1.0f).x, entity.getViewVector((float)1.0f).y, entity.getViewVector((float)1.0f).z, power * 2.0f, 0.0f);
        entityarrow.setSilent(true);
        entityarrow.setCritArrow(false);
        entityarrow.setBaseDamage(damage);
        entityarrow.setKnockback(knockback);
        world.addFreshEntity((Entity)entityarrow);
        world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.arrow.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.nextFloat() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static Bullet02Entity shoot(LivingEntity entity, LivingEntity target) {
        Bullet02Entity entityarrow = new Bullet02Entity((EntityType<? extends Bullet02Entity>)((EntityType)FsaModEntities.BULLET_02.get()), entity, entity.level(), null);
        double dx = target.getX() - entity.getX();
        double dy = target.getY() + (double)target.getEyeHeight() - 1.1;
        double dz = target.getZ() - entity.getZ();
        entityarrow.shoot(dx, dy - entityarrow.getY() + Math.hypot(dx, dz) * (double)0.2f, dz, 18.0f, 12.0f);
        entityarrow.setSilent(true);
        entityarrow.setBaseDamage(5.4);
        entityarrow.setKnockback(0);
        entityarrow.setCritArrow(false);
        entity.level().addFreshEntity((Entity)entityarrow);
        entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.arrow.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (RandomSource.create().nextFloat() * 0.5f + 1.0f));
        return entityarrow;
    }
}

