/*
 * Decompiled with CFR 0.152.
 */
package net.meowratic_works.fsa.entity;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.meowratic_works.fsa.FsaMod;
import net.meowratic_works.fsa.client.sound.CustomAutoSoundKeyframeHandler;
import net.meowratic_works.fsa.entity.Bullet01Entity;
import net.meowratic_works.fsa.entity.Bullet02Entity;
import net.meowratic_works.fsa.init.FsaModEntities;
import net.meowratic_works.fsa.item.UpgradeModule1Item;
import net.meowratic_works.fsa.network.ShellParticleMessage;
import net.meowratic_works.fsa.turret.ai.TargetDistanceMode;
import net.meowratic_works.fsa.turret.ai.TargetRangeMode;
import net.meowratic_works.fsa.turret.ai.TargetType;
import net.meowratic_works.fsa.turret.barrel.BarrelType;
import net.meowratic_works.fsa.turret.upgrades.TurretUpgrade;
import net.meowratic_works.fsa.turret.upgrades.TurretUpgrades;
import net.meowratic_works.fsa.utils.InventoryUtils;
import net.meowratic_works.fsa.utils.ItemInventoryUtils;
import net.meowratic_works.fsa.utils.RandomUtils;
import net.meowratic_works.fsa.utils.SoundUtils;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class TurretEntity
extends Mob
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final EntityDataAccessor<Boolean> HAS_SHIELD_UPGRADE = SynchedEntityData.defineId(TurretEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> IS_FIRING = SynchedEntityData.defineId(TurretEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Float> DISPLAY_HP = SynchedEntityData.defineId(TurretEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> DISPLAY_MHP = SynchedEntityData.defineId(TurretEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> DISPLAY_ARMOR = SynchedEntityData.defineId(TurretEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Optional<UUID>> CONTROLLING_PLAYER = SynchedEntityData.defineId(TurretEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    public static final EntityDataAccessor<Boolean> IS_ON = SynchedEntityData.defineId(TurretEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Float> BATTERY = SynchedEntityData.defineId(TurretEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final RawAnimation SHOOT_ANIM = RawAnimation.begin().thenPlay("fire");
    private float SHOOT_TIMER = 3.0f;
    private float NO_AMMO_TIMER = 200.0f;
    private boolean HAS_TARGET = false;
    public LivingEntity CURRENT_TARGET = null;
    public boolean HAS_SARA = false;
    private TurretState STATE = TurretState.IDLE;
    private TurretState LAST_STATE = null;
    private ItemStack lastUpgrade = ItemStack.EMPTY;
    private boolean upgradesInitialized = false;
    private EnumSet<TargetType> targetTypes = EnumSet.of(TargetType.MONSTERS);
    private TargetDistanceMode distanceMode = TargetDistanceMode.NEAREST;
    private TargetRangeMode rangeMode = TargetRangeMode.FULL_RANGE;
    private int DebugTick = 0;

    public TurretEntity(EntityType<? extends TurretEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected BodyRotationControl createBodyControl() {
        return new BodyRotationControl(this, this){

            public void clientTick() {
            }
        };
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HAS_SHIELD_UPGRADE, (Object)false);
        builder.define(IS_FIRING, (Object)false);
        builder.define(DISPLAY_HP, (Object)Float.valueOf(0.0f));
        builder.define(DISPLAY_MHP, (Object)Float.valueOf(0.0f));
        builder.define(CONTROLLING_PLAYER, Optional.empty());
        builder.define(IS_ON, (Object)false);
        builder.define(BATTERY, (Object)Float.valueOf(0.0f));
        builder.define(DISPLAY_ARMOR, (Object)Float.valueOf(0.0f));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("IsOn", ((Boolean)this.entityData.get(IS_ON)).booleanValue());
        tag.putFloat("Battery", ((Float)this.entityData.get(BATTERY)).floatValue());
        ((Optional)this.entityData.get(CONTROLLING_PLAYER)).ifPresent(uuid -> tag.putUUID("Controller", uuid));
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(IS_ON, (Object)tag.getBoolean("IsOn"));
        this.entityData.set(BATTERY, (Object)Float.valueOf(tag.getFloat("Battery")));
        if (tag.hasUUID("Controller")) {
            this.entityData.set(CONTROLLING_PLAYER, Optional.of(tag.getUUID("Controller")));
        } else {
            this.entityData.set(CONTROLLING_PLAYER, Optional.empty());
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "turretController", 0, this::turretPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "shoot_controller", state -> PlayState.STOP).triggerableAnim("fire", SHOOT_ANIM).setSoundKeyframeHandler(new CustomAutoSoundKeyframeHandler()));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected PlayState turretPredicate(AnimationState<?> state) {
        AnimationController controller = state.getController();
        boolean fire = (Boolean)this.getEntityData().get(IS_FIRING);
        if (fire && this.barrelType() != BarrelType.SINGLE_AT) {
            controller.setAnimation(RawAnimation.begin().thenLoop("fire"));
        } else {
            controller.setAnimation(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.CONTINUE;
    }

    protected double TARGET_RANGE() {
        return 32.0;
    }

    protected float BULLET_DAMAGE() {
        return 5.0f;
    }

    protected int BULLET_KNOCKBACK() {
        return 1;
    }

    protected float FIRE_RATE() {
        return 3.0f;
    }

    protected float BULLET_SPEED() {
        return 4.4f;
    }

    protected float AIM_SPEED() {
        return 0.3f;
    }

    protected Vec3 BULLET_POS1() {
        double xof = 0.0;
        double yof = 0.0;
        double zof = 1.8;
        return new Vec3(xof, yof, zof);
    }

    protected Vec3 BULLET_POS2() {
        double xof = 0.0;
        double yof = 0.0;
        double zof = 1.8;
        return new Vec3(xof, yof, zof);
    }

    protected String AMMO_NEEDED() {
        return "fsa:ammo_1";
    }

    protected String SHOOT_SOUND() {
        return "fsa:mg15_shoot";
    }

    protected String SHOOT_SOUND2() {
        return "fsa:mg15_shoot";
    }

    protected String PARTICLE_ID() {
        return "fsa:empty_casing";
    }

    protected Vec3 PARTICLE_POS() {
        double foward = 0.08;
        double right = 0.1;
        double up = 0.05;
        return new Vec3(foward, right, up);
    }

    protected Vec3 PARTICLE_MOTION() {
        float foward = -0.05f;
        float right = 0.25f;
        float up = 0.15f;
        return new Vec3((double)foward, (double)right, (double)up);
    }

    protected Vec3 PARTICLE_MOTION2() {
        float foward = -0.05f;
        float right = 0.25f;
        float up = 0.15f;
        return new Vec3((double)foward, (double)right, (double)up);
    }

    protected BarrelType barrelType() {
        return BarrelType.SINGLE;
    }

    /*
     * Unable to fully structure code
     */
    public void turretTick(LevelAccessor world, double x, double y, double z, Entity turret) {
        am = this.getAmmo(turret);
        isOn = (Boolean)turret.getEntityData().get(TurretEntity.IS_ON);
        if (!(turret instanceof LivingEntity)) {
            return;
        }
        livingTurret = (LivingEntity)turret;
        if (this.CURRENT_TARGET == null && isOn) {
            this.CURRENT_TARGET = this.findTarget(world, x, y, z);
        }
        if ((var13_9 = this.CURRENT_TARGET) instanceof LivingEntity) {
            target = var13_9;
            if (!target.isAlive()) {
                this.CURRENT_TARGET = null;
                this.HAS_TARGET = false;
                this.STATE = TurretState.IDLE;
                return;
            }
            if (!this.HAS_TARGET) {
                this.targetFoundFx(turret);
                this.HAS_TARGET = true;
            }
            this.pushTarget(world, turret, x, y, z);
            this.aimAtTarget(turret, (Entity)target);
            hasLOS = livingTurret.hasLineOfSight((Entity)target);
            aimed = this.isAimedAt(turret, (Entity)target, 10.0);
            this.turretStateHandler(turret, aimed, hasLOS, am);
        }
        if (this.SHOOT_TIMER > 0.0f) {
            this.SHOOT_TIMER -= 1.0f;
        }
        if (this.NO_AMMO_TIMER > 0.0f) {
            this.NO_AMMO_TIMER -= 1.0f;
        }
        this.turretTargetHandler(turret);
        this.turretDistanceHandler(turret);
        this.turretRangeHandler(turret);
        this.batteryHandler(turret);
        if (!this.level().isClientSide && !this.upgradesInitialized) {
            TurretEntity.applyUpgrade((LivingEntity)this);
            this.lastUpgrade = InventoryUtils.getItemInSlot((Entity)this, 13).copy();
            this.upgradesInitialized = true;
        }
        if (!this.level().isClientSide && !ItemStack.isSameItemSameComponents((ItemStack)(current = InventoryUtils.getItemInSlot((Entity)this, 13)), (ItemStack)this.lastUpgrade)) {
            TurretEntity.applyUpgrade((LivingEntity)this);
            this.lastUpgrade = current.copy();
            SoundUtils.playServerSound(this.level(), ResourceLocation.parse((String)"fsa:upgrade_install"), this.position(), 1.0f, 1.0f);
            System.out.println("upgrade state changed");
        }
        if (!this.level().isClientSide) {
            this.getEntityData().set(TurretEntity.DISPLAY_HP, (Object)Float.valueOf(this.getHealth()));
            this.getEntityData().set(TurretEntity.DISPLAY_MHP, (Object)Float.valueOf(this.getMaxHealth()));
            this.getEntityData().set(TurretEntity.DISPLAY_ARMOR, (Object)Float.valueOf(this.getArmorValue()));
        }
        this.noAmmoFx(turret);
        if (this.STATE != TurretState.FIRE || !(this.SHOOT_TIMER > 0.0f) || this.getAmmo(turret) <= 0) ** GOTO lbl-1000
        if (((Boolean)turret.getEntityData().get(TurretEntity.IS_ON)).booleanValue()) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        firing = v0;
        turret.getEntityData().set(TurretEntity.IS_FIRING, (Object)firing);
    }

    /*
     * Unable to fully structure code
     */
    public void turretStateHandler(Entity entity, boolean aim, boolean hasLOS, int am) {
        if (this.CURRENT_TARGET == null) {
            this.STATE = TurretState.IDLE;
            return;
        }
        if (!aim || !hasLOS) {
            this.STATE = TurretState.IDLE;
            return;
        }
        if (am <= 0) ** GOTO lbl-1000
        if (((Boolean)entity.getEntityData().get(TurretEntity.IS_ON)).booleanValue()) {
            this.STATE = TurretState.FIRE;
        } else lbl-1000:
        // 2 sources

        {
            this.STATE = TurretState.STOP;
            this.CURRENT_TARGET = null;
        }
        this.turretStateEvents(entity);
    }

    public void turretStateEvents(Entity entity) {
        switch (this.STATE.ordinal()) {
            case 1: {
                this.tryShoot(entity);
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void tryShoot(Entity entity) {
        Vec3 pos1 = this.BULLET_POS1();
        Vec3 pos2 = this.BULLET_POS2();
        if (this.STATE != TurretState.FIRE) {
            return;
        }
        if (this.SHOOT_TIMER > 0.0f) {
            return;
        }
        int am = this.getAmmo(entity);
        if (am <= 0) {
            this.STATE = TurretState.STOP;
            return;
        }
        if (this.barrelType() == BarrelType.SINGLE) {
            this.fireGun(entity, pos1.x, pos1.y, pos1.z);
        } else if (this.barrelType() == BarrelType.DOUBLE) {
            this.fire2Gun(entity, pos2.x, pos2.y, pos2.z);
            this.fireGun(entity, pos1.x, pos1.y, pos1.z);
        } else if (this.barrelType() == BarrelType.SINGLE_AT) {
            this.fire3Gun(entity, pos1.x, pos1.y, pos1.z);
        }
    }

    public void shootFX(Entity entity) {
        if (this.barrelType() == BarrelType.SINGLE) {
            SoundUtils.playServerSound(entity.level(), ResourceLocation.parse((String)this.SHOOT_SOUND()), entity.position(), 1.0f, 1.0f);
        } else if (this.barrelType() == BarrelType.DOUBLE) {
            SoundUtils.playServerSound(entity.level(), ResourceLocation.parse((String)this.SHOOT_SOUND2()), entity.position(), 1.0f, 1.0f);
        } else if (this.barrelType() == BarrelType.SINGLE_AT) {
            SoundUtils.playServerSound(entity.level(), ResourceLocation.parse((String)this.SHOOT_SOUND()), entity.position(), 1.0f, 1.0f);
        }
    }

    public void targetFoundFx(Entity entity) {
        Level level = entity.level();
        boolean isOn = (Boolean)entity.getEntityData().get(IS_ON);
        if (RandomUtils.percent(level, 30) && this.HAS_SARA && isOn) {
            SoundUtils.playServerSound(this.level(), ResourceLocation.parse((String)"fsa:sara_target_located"), this.position(), 1.0f, 1.0f);
        }
    }

    public void noAmmoFx(Entity entity) {
        boolean isOn = (Boolean)entity.getEntityData().get(IS_ON);
        int am = this.getAmmo(entity);
        if (this.NO_AMMO_TIMER <= 0.0f && this.HAS_SARA && isOn && am <= 0) {
            SoundUtils.playServerSound(this.level(), ResourceLocation.parse((String)"fsa:sara_noammo"), this.position(), 1.0f, 1.0f);
            this.NO_AMMO_TIMER = 200.0f;
        }
    }

    public int getAmmo(Entity entity) {
        InventoryUtils ammo = new InventoryUtils();
        int available = ammo.getTotal(entity, (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)this.AMMO_NEEDED())));
        if (available > 0) {
            return available;
        }
        return 0;
    }

    public void consumeAmmo(Entity entity) {
        InventoryUtils ammo = new InventoryUtils();
        int available = ammo.getTotal(entity, (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)this.AMMO_NEEDED())));
        if (available >= 1) {
            ammo.extract(entity, (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)this.AMMO_NEEDED())), 1);
        }
    }

    public void particleHandler(Entity shooter) {
        if (this.barrelType() == BarrelType.SINGLE) {
            Vec3 pos = this.PARTICLE_POS();
            Vec3 pspeed = this.PARTICLE_MOTION();
            PacketDistributor.sendToPlayersTrackingEntity((Entity)shooter, (CustomPacketPayload)new ShellParticleMessage(shooter.getId(), pos.x, pos.y, pos.z, (float)pspeed.x, (float)pspeed.y, (float)pspeed.z, this.PARTICLE_ID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            Vec3 pos = this.PARTICLE_POS();
            Vec3 pspeed = this.PARTICLE_MOTION();
            Vec3 pspeed2 = this.PARTICLE_MOTION2();
            PacketDistributor.sendToPlayersTrackingEntity((Entity)shooter, (CustomPacketPayload)new ShellParticleMessage(shooter.getId(), pos.x, pos.y, pos.z, (float)pspeed.x, (float)pspeed.y, (float)pspeed.z, this.PARTICLE_ID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            PacketDistributor.sendToPlayersTrackingEntity((Entity)shooter, (CustomPacketPayload)new ShellParticleMessage(shooter.getId(), pos.x, pos.y, pos.z, (float)pspeed2.x, (float)pspeed2.y, (float)pspeed2.z, this.PARTICLE_ID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void turretTargetHandler(Entity entity) {
        if (entity == null) {
            return;
        }
        if (!InventoryUtils.hasItemInSlot(entity, 0, "fsa:sara_module")) {
            this.targetTypes = EnumSet.of(TargetType.MONSTERS);
            this.HAS_SARA = false;
            return;
        }
        ItemStack moduleStack = InventoryUtils.getItemInSlot(entity, 0);
        if (!this.HAS_SARA) {
            this.HAS_SARA = true;
        }
        if (moduleStack.isEmpty()) {
            this.targetTypes = EnumSet.of(TargetType.MONSTERS);
            this.HAS_SARA = false;
            return;
        }
        EnumSet<TargetType> newTargets = EnumSet.noneOf(TargetType.class);
        for (int slot = 0; slot <= 5; ++slot) {
            TargetType type = this.getTargetTypeFromSlot(moduleStack, slot);
            if (type == null) continue;
            newTargets.add(type);
        }
        if (newTargets.isEmpty()) {
            newTargets = EnumSet.of(TargetType.MONSTERS);
        }
        this.targetTypes = newTargets;
    }

    private TargetType getTargetTypeFromSlot(ItemStack module, int slot) {
        if (ItemInventoryUtils.isItemInSlot(module, slot, "fsa:target_players")) {
            return TargetType.PLAYERS;
        }
        if (ItemInventoryUtils.isItemInSlot(module, slot, "fsa:target_animals")) {
            return TargetType.ANIMALS;
        }
        if (ItemInventoryUtils.isItemInSlot(module, slot, "fsa:target_monsters")) {
            return TargetType.MONSTERS;
        }
        return null;
    }

    public void turretDistanceHandler(Entity entity) {
        if (entity == null) {
            return;
        }
        if (!InventoryUtils.hasItemInSlot(entity, 0, "fsa:sara_module")) {
            this.distanceMode = TargetDistanceMode.NEAREST;
            return;
        }
        ItemStack moduleStack = InventoryUtils.getItemInSlot(entity, 0);
        if (moduleStack.isEmpty()) {
            this.distanceMode = TargetDistanceMode.NEAREST;
            return;
        }
        TargetDistanceMode newMode = this.getDistanceItem(moduleStack, 6);
        if (newMode == null) {
            newMode = TargetDistanceMode.NEAREST;
        }
        this.distanceMode = newMode;
    }

    public TargetDistanceMode getDistanceItem(ItemStack module, int slot) {
        if (ItemInventoryUtils.isItemInSlot(module, slot, "fsa:distance_nearest")) {
            return TargetDistanceMode.NEAREST;
        }
        if (ItemInventoryUtils.isItemInSlot(module, slot, "fsa:distance_farthest")) {
            return TargetDistanceMode.FARTHEST;
        }
        return null;
    }

    public void turretRangeHandler(Entity entity) {
        if (entity == null) {
            return;
        }
        if (!InventoryUtils.hasItemInSlot(entity, 0, "fsa:sara_module")) {
            this.rangeMode = TargetRangeMode.FULL_RANGE;
            return;
        }
        ItemStack moduleStack = InventoryUtils.getItemInSlot(entity, 0);
        if (moduleStack.isEmpty()) {
            this.rangeMode = TargetRangeMode.FULL_RANGE;
            return;
        }
        TargetRangeMode newMode = this.getRangeItem(moduleStack, 7);
        if (newMode == null) {
            newMode = TargetRangeMode.FULL_RANGE;
        }
        this.rangeMode = newMode;
    }

    public TargetRangeMode getRangeItem(ItemStack module, int slot) {
        if (ItemInventoryUtils.isItemInSlot(module, slot, "fsa:range_full")) {
            return TargetRangeMode.FULL_RANGE;
        }
        if (ItemInventoryUtils.isItemInSlot(module, slot, "fsa:range_half_max")) {
            return TargetRangeMode.HALF_TO_MAX;
        }
        if (ItemInventoryUtils.isItemInSlot(module, slot, "fsa:range_near_max")) {
            return TargetRangeMode.NEAR_MAX;
        }
        if (ItemInventoryUtils.isItemInSlot(module, slot, "fsa:range_close")) {
            return TargetRangeMode.CLOSE_ONLY;
        }
        return null;
    }

    public void batteryHandler(Entity entity) {
        ItemStack stack;
        float battery = ((Float)entity.getEntityData().get(BATTERY)).floatValue();
        boolean isOn = (Boolean)entity.getEntityData().get(IS_ON);
        if (InventoryUtils.hasItemInSlot(entity, 14, "fsa:battery") && !((CustomData)(stack = InventoryUtils.getItemInSlot(entity, 14)).getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getBoolean("discharged")) {
            CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> tag.putBoolean("discharged", true));
            entity.getEntityData().set(BATTERY, (Object)Float.valueOf(100.0f));
        }
        if (battery > 0.0f && isOn) {
            entity.getEntityData().set(BATTERY, (Object)Float.valueOf(battery - 0.01f));
        }
        if (battery <= 0.0f && isOn) {
            entity.getEntityData().set(IS_ON, (Object)false);
            entity.getEntityData().set(BATTERY, (Object)Float.valueOf(0.0f));
            if (this.HAS_SARA) {
                SoundUtils.playServerSound(this.level(), ResourceLocation.parse((String)"fsa:sara_low_battery"), this.position(), 1.0f, 1.0f);
            }
            System.out.println("System Off");
        }
    }

    public static void applyUpgrade(LivingEntity turret) {
        if (turret.level().isClientSide) {
            return;
        }
        ItemStack stack = InventoryUtils.getItemInSlot((Entity)turret, 13);
        for (TurretUpgrade upgrade : TurretUpgrades.UPGRADES.values()) {
            upgrade.remove(turret);
        }
        if (stack.isEmpty()) {
            return;
        }
        TurretUpgrade upgrade = TurretUpgrades.UPGRADES.get(stack.getItem());
        if (upgrade != null) {
            upgrade.apply(turret);
            System.out.println("Upgrade=" + (stack.getItem() instanceof UpgradeModule1Item) + " HP=" + turret.getHealth() + " MHP=" + turret.getMaxHealth());
        }
    }

    public void pushTarget(LevelAccessor world, Entity pusher, double x, double y, double z) {
        Predicate<Entity> predicate;
        AABB box = AABB.ofSize((Vec3)new Vec3(x, y, z), (double)3.0, (double)3.0, (double)3.0);
        List targets = world.getEntitiesOfClass(LivingEntity.class, box, predicate = this.buildTargetPredicate());
        if (targets.isEmpty()) {
            return;
        }
        LivingEntity target = targets.stream().min(Comparator.comparingDouble(e -> e.distanceToSqr(x, y, z))).orElse(null);
        if (target == null) {
            return;
        }
        Vec3 look = pusher.getLookAngle();
        double strength = 0.6;
        double yBoost = 0.1;
        target.push(look.x * strength, look.y * strength + yBoost, look.z * strength);
    }

    private Predicate<Entity> buildTargetPredicate() {
        return entity -> {
            if (!(entity instanceof LivingEntity)) {
                return false;
            }
            LivingEntity living = (LivingEntity)entity;
            if (!living.isAlive()) {
                return false;
            }
            double distSqr = entity.distanceToSqr((Entity)this);
            double minRange = this.TARGET_RANGE() * this.rangeMode.getMinFactor();
            double maxRange = this.TARGET_RANGE() * this.rangeMode.getMaxFactor();
            double minSqr = minRange * minRange;
            double maxSqr = maxRange * maxRange;
            if (distSqr < minSqr || distSqr > maxSqr) {
                return false;
            }
            for (TargetType type : this.targetTypes) {
                if (!type.matches(living)) continue;
                return true;
            }
            return false;
        };
    }

    private LivingEntity findTarget(LevelAccessor level, double x, double y, double z) {
        AABB box = AABB.ofSize((Vec3)new Vec3(x, y, z), (double)this.TARGET_RANGE(), (double)this.TARGET_RANGE(), (double)this.TARGET_RANGE());
        Predicate<Entity> predicate = this.buildTargetPredicate();
        Comparator<LivingEntity> comparator = Comparator.comparingDouble(e -> e.distanceToSqr(x, y, z));
        if (this.distanceMode == TargetDistanceMode.FARTHEST) {
            comparator = comparator.reversed();
        }
        return level.getEntitiesOfClass(LivingEntity.class, box, predicate).stream().min(comparator).orElse(null);
    }

    private void aimAtTarget(Entity turret, Entity target) {
        Vec3 targetPos = new Vec3(target.getX(), target.getY() + (double)target.getBbHeight() * 0.5, target.getZ());
        FsaMod.queueServerWork(1, () -> this.smoothLookAt(turret, EntityAnchorArgument.Anchor.EYES, targetPos, this.AIM_SPEED()));
    }

    public void toggleTarget(TargetType type) {
        if (this.targetTypes.contains((Object)type)) {
            this.targetTypes.remove((Object)type);
        } else {
            this.targetTypes.add(type);
        }
    }

    public void smoothLookAt(Entity entity, EntityAnchorArgument.Anchor anchor, Vec3 targetPos, float smoothness) {
        Vec3 origin = anchor.apply(entity);
        double dx = targetPos.x - origin.x;
        double dy = targetPos.y - origin.y;
        double dz = targetPos.z - origin.z;
        double horizontalDist = Math.sqrt(dx * dx + dz * dz);
        float targetPitch = (float)(-(Math.atan2(dy, horizontalDist) * 57.29577951308232));
        float targetYaw = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
        float currentYaw = entity.getYRot();
        float currentPitch = entity.getXRot();
        float newYaw = this.lerpAngle(currentYaw, targetYaw, smoothness);
        float newPitch = this.lerpAngle(currentPitch, targetPitch, smoothness);
        entity.setYRot(newYaw);
        entity.setXRot(targetPitch);
        entity.setYHeadRot(newYaw);
    }

    private float lerpAngle(float current, float target, float t) {
        float delta = Mth.wrapDegrees((float)(target - current));
        return current + delta * t;
    }

    private boolean isAimedAt(Entity turret, Entity target, double toleranceDegrees) {
        double threshold;
        Vec3 toTarget;
        Vec3 look = turret.getLookAngle().normalize();
        double dot = look.dot(toTarget = target.position().add(0.0, (double)target.getBbHeight() * 0.5, 0.0).subtract(turret.getEyePosition()).normalize());
        return dot > (threshold = Math.cos(Math.toRadians(toleranceDegrees)));
    }

    private void fireGun(Entity shooter, double xof, double yof, double zof) {
        Level level = shooter.level();
        if (level.isClientSide()) {
            return;
        }
        Projectile bullet = this.createBullet(level, shooter);
        Vec3 look = shooter.getLookAngle();
        Vec3 spawnPos = shooter.getEyePosition().add(look.scale(zof)).add(xof, yof, 0.0);
        bullet.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
        float speed = this.BULLET_SPEED();
        bullet.shoot(look.x, look.y, look.z, speed, 0.0f);
        level.addFreshEntity((Entity)bullet);
        this.shootFX(shooter);
        this.consumeAmmo(shooter);
        this.particleHandler(shooter);
        this.SHOOT_TIMER = this.FIRE_RATE();
    }

    private void fire3Gun(Entity shooter, double xof, double yof, double zof) {
        Level level = shooter.level();
        if (level.isClientSide()) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.triggerAnim("shoot_controller", "fire");
        }
        Projectile bullet = this.createShell(level, shooter);
        Vec3 look = shooter.getLookAngle();
        Vec3 spawnPos = shooter.getEyePosition().add(look.scale(zof)).add(xof, yof, 0.0);
        bullet.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
        float speed = this.BULLET_SPEED();
        bullet.shoot(look.x, look.y, look.z, speed, 0.0f);
        level.addFreshEntity((Entity)bullet);
        this.shootFX(shooter);
        this.consumeAmmo(shooter);
        this.SHOOT_TIMER = this.FIRE_RATE();
    }

    private void fire2Gun(Entity shooter, double xof, double yof, double zof) {
        Level level = shooter.level();
        if (level.isClientSide()) {
            return;
        }
        Projectile bullet = this.createBullet(level, shooter);
        Vec3 look = shooter.getLookAngle();
        Vec3 spawnPos = shooter.getEyePosition().add(look.scale(zof)).add(xof, yof, 0.0);
        bullet.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
        float speed = this.BULLET_SPEED();
        bullet.shoot(look.x, look.y, look.z, speed, 0.0f);
        level.addFreshEntity((Entity)bullet);
        this.shootFX(shooter);
        this.consumeAmmo(shooter);
        this.particleHandler(shooter);
    }

    private Projectile createBullet(Level level, Entity shooter) {
        Bullet01Entity bullet = new Bullet01Entity((EntityType)FsaModEntities.BULLET_01.get(), level){

            public byte getPierceLevel() {
                return 0;
            }

            @Override
            protected void doKnockback(LivingEntity target, DamageSource source) {
                if (TurretEntity.this.BULLET_KNOCKBACK() <= 0) {
                    return;
                }
                double resistance = target.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE);
                double strength = Math.max(0.0, 1.0 - resistance);
                Vec3 push = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale((double)TurretEntity.this.BULLET_KNOCKBACK() * 0.6 * strength);
                if (push.lengthSqr() > 0.0) {
                    target.push(push.x, 0.1, push.z);
                }
            }

            @Override
            public float getDmg() {
                return TurretEntity.this.BULLET_DAMAGE();
            }
        };
        bullet.setOwner(shooter);
        bullet.setBaseDamage(0.0);
        bullet.setSilent(true);
        return bullet;
    }

    private Projectile createShell(Level level, Entity shooter) {
        Bullet02Entity bullet = new Bullet02Entity((EntityType)FsaModEntities.BULLET_02.get(), level){

            public byte getPierceLevel() {
                return 0;
            }

            @Override
            protected void doKnockback(LivingEntity target, DamageSource source) {
                if (TurretEntity.this.BULLET_KNOCKBACK() <= 0) {
                    return;
                }
                double resistance = target.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE);
                double strength = Math.max(0.0, 1.0 - resistance);
                Vec3 push = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale((double)TurretEntity.this.BULLET_KNOCKBACK() * 0.6 * strength);
                if (push.lengthSqr() > 0.0) {
                    target.push(push.x, 0.1, push.z);
                }
            }

            @Override
            public float getDmg() {
                return TurretEntity.this.BULLET_DAMAGE();
            }
        };
        bullet.setOwner(shooter);
        bullet.setBaseDamage(0.0);
        bullet.setSilent(true);
        return bullet;
    }

    public static enum TurretState {
        IDLE,
        FIRE,
        STOP;

    }
}

