/*
 * Decompiled with CFR 0.152.
 */
package net.meowratic_works.fsa.init;

import net.meowratic_works.fsa.entity.AC25Entity;
import net.meowratic_works.fsa.entity.AC26Entity;
import net.meowratic_works.fsa.entity.AMG26Entity;
import net.meowratic_works.fsa.entity.ATC24Entity;
import net.meowratic_works.fsa.entity.Bullet01Entity;
import net.meowratic_works.fsa.entity.Bullet02Entity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class FsaModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"fsa");
    public static final DeferredHolder<EntityType<?>, EntityType<AMG26Entity>> AMG_26 = FsaModEntities.register("amg_26", EntityType.Builder.of(AMG26Entity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.7f, 1.2f));
    public static final DeferredHolder<EntityType<?>, EntityType<Bullet01Entity>> BULLET_01 = FsaModEntities.register("bullet_01", EntityType.Builder.of(Bullet01Entity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.3f, 0.3f));
    public static final DeferredHolder<EntityType<?>, EntityType<AC25Entity>> AC_25 = FsaModEntities.register("ac_25", EntityType.Builder.of(AC25Entity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.7f, 1.4f));
    public static final DeferredHolder<EntityType<?>, EntityType<AC26Entity>> AC_26 = FsaModEntities.register("ac_26", EntityType.Builder.of(AC26Entity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.7f, 1.2f));
    public static final DeferredHolder<EntityType<?>, EntityType<ATC24Entity>> ATC_24 = FsaModEntities.register("atc_24", EntityType.Builder.of(ATC24Entity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.9f, 1.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<Bullet02Entity>> BULLET_02 = FsaModEntities.register("bullet_02", EntityType.Builder.of(Bullet02Entity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.3f, 0.3f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerEntity(Capabilities.ItemHandler.ENTITY, (EntityType)AMG_26.get(), (living, context) -> living.getInventory());
        event.registerEntity(Capabilities.ItemHandler.ENTITY, (EntityType)AC_25.get(), (living, context) -> living.getInventory());
        event.registerEntity(Capabilities.ItemHandler.ENTITY, (EntityType)AC_26.get(), (living, context) -> living.getInventory());
        event.registerEntity(Capabilities.ItemHandler.ENTITY, (EntityType)ATC_24.get(), (living, context) -> living.getInventory());
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        AMG26Entity.init(event);
        AC25Entity.init(event);
        AC26Entity.init(event);
        ATC24Entity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)AMG_26.get(), AMG26Entity.createAttributes().build());
        event.put((EntityType)AC_25.get(), AC25Entity.createAttributes().build());
        event.put((EntityType)AC_26.get(), AC26Entity.createAttributes().build());
        event.put((EntityType)ATC_24.get(), ATC24Entity.createAttributes().build());
    }
}

