/*
 * Decompiled with CFR 0.152.
 */
package net.meowratic_works.fsa.network;

import net.meowratic_works.fsa.FsaMod;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record PlaySoundMessage(int entityId, ResourceLocation soundId, SoundSource source, float volume, float pitch) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PlaySoundMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"fsa", (String)"play_sound"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PlaySoundMessage> STREAM_CODEC = StreamCodec.of((buf, msg) -> {
        buf.writeInt(msg.entityId);
        buf.writeResourceLocation(msg.soundId);
        buf.writeEnum((Enum)msg.source);
        buf.writeFloat(msg.volume);
        buf.writeFloat(msg.pitch);
    }, buf -> new PlaySoundMessage(buf.readInt(), buf.readResourceLocation(), (SoundSource)buf.readEnum(SoundSource.class), buf.readFloat(), buf.readFloat()));

    public CustomPacketPayload.Type<PlaySoundMessage> type() {
        return TYPE;
    }

    public static void handle(PlaySoundMessage msg, IPayloadContext ctx) {
        if (ctx.flow() != PacketFlow.CLIENTBOUND) {
            return;
        }
        ctx.enqueueWork(() -> {
            Minecraft mc = Minecraft.getInstance();
            if (mc.level == null) {
                return;
            }
            Entity entity = mc.level.getEntity(msg.entityId);
            if (entity == null) {
                return;
            }
            SoundEvent sound = SoundEvent.createVariableRangeEvent((ResourceLocation)msg.soundId);
            mc.level.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), sound, msg.source, msg.volume, msg.pitch, false);
        }).exceptionally(e -> {
            ctx.connection().disconnect((Component)Component.literal((String)e.getMessage()));
            return null;
        });
    }

    @SubscribeEvent
    public static void register(FMLCommonSetupEvent event) {
        FsaMod.addNetworkMessage(TYPE, STREAM_CODEC, PlaySoundMessage::handle);
    }
}

