/*
 * Decompiled with CFR 0.152.
 */
package net.meowratic_works.fsa.network;

import net.meowratic_works.fsa.FsaMod;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record RequestPlaySoundMessage(int entityId, ResourceLocation soundId, SoundSource source, float volume, float pitch) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RequestPlaySoundMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"fsa", (String)"request_play_sound"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RequestPlaySoundMessage> STREAM_CODEC = StreamCodec.of((buf, msg) -> {
        buf.writeInt(msg.entityId);
        buf.writeResourceLocation(msg.soundId);
        buf.writeEnum((Enum)msg.source);
        buf.writeFloat(msg.volume);
        buf.writeFloat(msg.pitch);
    }, buf -> new RequestPlaySoundMessage(buf.readInt(), buf.readResourceLocation(), (SoundSource)buf.readEnum(SoundSource.class), buf.readFloat(), buf.readFloat()));

    public CustomPacketPayload.Type<RequestPlaySoundMessage> type() {
        return TYPE;
    }

    public static void handle(RequestPlaySoundMessage msg, IPayloadContext ctx) {
        if (ctx.flow() != PacketFlow.SERVERBOUND) {
            return;
        }
        ctx.enqueueWork(() -> {
            ServerPlayer sender = (ServerPlayer)ctx.player();
            if (sender == null) {
                return;
            }
            Entity entity = sender.level().getEntity(msg.entityId);
            if (entity == null) {
                return;
            }
            if (entity.distanceToSqr((Entity)sender) > 4096.0) {
                return;
            }
        });
    }

    @SubscribeEvent
    public static void register(FMLCommonSetupEvent event) {
        FsaMod.addNetworkMessage(TYPE, STREAM_CODEC, RequestPlaySoundMessage::handle);
    }
}

