/*
 * Decompiled with CFR 0.152.
 */
package net.meowratic_works.fsa.network;

import net.meowratic_works.fsa.FsaMod;
import net.meowratic_works.fsa.utils.ParticleUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record ShellParticleMessage(int entityId, double forward, double right, double up, float velForward, float velRight, float velUp, String particleId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ShellParticleMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"fsa", (String)"shell_particle"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ShellParticleMessage> STREAM_CODEC = StreamCodec.of((buf, msg) -> {
        buf.writeInt(msg.entityId);
        buf.writeDouble(msg.forward);
        buf.writeDouble(msg.right);
        buf.writeDouble(msg.up);
        buf.writeFloat(msg.velForward);
        buf.writeFloat(msg.velRight);
        buf.writeFloat(msg.velUp);
        buf.writeUtf(msg.particleId);
    }, buf -> new ShellParticleMessage(buf.readInt(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readUtf()));

    public CustomPacketPayload.Type<ShellParticleMessage> type() {
        return TYPE;
    }

    public static void handleData(ShellParticleMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.CLIENTBOUND) {
            context.enqueueWork(() -> {
                Minecraft mc = Minecraft.getInstance();
                if (mc.level == null) {
                    return;
                }
                Entity entity = mc.level.getEntity(message.entityId);
                if (entity == null) {
                    return;
                }
                ParticleUtil.shellClient(entity, message.forward, message.right, message.up, message.particleId, message.velForward, message.velRight, message.velUp);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        FsaMod.addNetworkMessage(TYPE, STREAM_CODEC, ShellParticleMessage::handleData);
    }
}

