/*
 * Decompiled with CFR 0.152.
 */
package net.meowratic_works.fsa.procedures;

import java.util.Comparator;
import java.util.List;
import net.meowratic_works.fsa.FsaMod;
import net.meowratic_works.fsa.entity.Bullet01Entity;
import net.meowratic_works.fsa.init.FsaModEntities;
import net.meowratic_works.fsa.utils.SoundUtils;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AMG26AIProcedure {
    private static final double TARGET_RANGE = 32.0;
    private static final float BULLET_DAMAGE = 5.0f;
    private static final int BULLET_KNOCKBACK = 1;
    private static float rotationCooldown = 1.0f;
    private static float firerate = 3.0f;
    private static float shootTimer = 3.0f;
    private static boolean hadTarget = false;

    public static void execute(LevelAccessor world, double x, double y, double z, Entity turret) {
        if (turret == null) {
            return;
        }
        Entity target = AMG26AIProcedure.findNearestPlayer(world, x, y, z);
        if (target != null) {
            AMG26AIProcedure.aimAtTarget(turret, target);
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                if (turret instanceof LivingEntity) {
                    LivingEntity livingTurret = (LivingEntity)turret;
                    if (!hadTarget) {
                        FsaMod.queueServerWork(1, () -> {
                            hadTarget = true;
                        });
                        SoundUtils.playServerSound(turret.level(), ResourceLocation.parse((String)"fsa:maria_target_located"), turret.position(), 1.0f, 1.0f);
                        System.out.println("targeted");
                    }
                    boolean hasLOS = livingTurret.hasLineOfSight((Entity)livingTarget);
                    boolean aimed = AMG26AIProcedure.isAimedAt(turret, target, 10.0);
                    if (hasLOS && aimed && shootTimer <= 0.0f) {
                        AMG26AIProcedure.fireBullet(turret);
                    }
                }
            }
        } else if (hadTarget) {
            hadTarget = false;
            System.out.println("NOtargeted");
        }
        if (shootTimer > 0.0f) {
            shootTimer -= 1.0f;
        }
    }

    private static Entity findNearestPlayer(LevelAccessor world, double x, double y, double z) {
        List players = world.getEntitiesOfClass(Animal.class, AABB.ofSize((Vec3)new Vec3(x, y, z), (double)32.0, (double)32.0, (double)32.0));
        return players.stream().min(Comparator.comparingDouble(p -> p.distanceToSqr(x, y, z))).orElse(null);
    }

    private static void aimAtTarget(Entity turret, Entity target) {
        Vec3 targetPos = new Vec3(target.getX(), target.getY() + (double)target.getBbHeight() * 0.5, target.getZ());
        FsaMod.queueServerWork(1, () -> AMG26AIProcedure.smoothLookAt(turret, EntityAnchorArgument.Anchor.EYES, targetPos, 0.3f));
    }

    public static void smoothLookAt(Entity entity, EntityAnchorArgument.Anchor anchor, Vec3 targetPos, float smoothness) {
        Vec3 origin = anchor.apply(entity);
        double dx = targetPos.x - origin.x;
        double dy = targetPos.y - origin.y;
        double dz = targetPos.z - origin.z;
        double horizontalDist = Math.sqrt(dx * dx + dz * dz);
        float targetPitch = (float)(-(Math.atan2(dy, horizontalDist) * 57.29577951308232));
        float targetYaw = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
        float currentYaw = entity.getYRot();
        float currentPitch = entity.getXRot();
        float newYaw = AMG26AIProcedure.lerpAngle(currentYaw, targetYaw, smoothness);
        float newPitch = AMG26AIProcedure.lerpAngle(currentPitch, targetPitch, smoothness);
        entity.setYRot(newYaw);
        entity.setXRot(targetPitch);
        entity.setYHeadRot(newYaw);
    }

    private static float lerpAngle(float current, float target, float t) {
        float delta = Mth.wrapDegrees((float)(target - current));
        return current + delta * t;
    }

    private static boolean isAimedAt(Entity turret, Entity target, double toleranceDegrees) {
        double threshold;
        Vec3 toTarget;
        Vec3 look = turret.getLookAngle().normalize();
        double dot = look.dot(toTarget = target.position().add(0.0, (double)target.getBbHeight() * 0.5, 0.0).subtract(turret.getEyePosition()).normalize());
        return dot > (threshold = Math.cos(Math.toRadians(toleranceDegrees)));
    }

    private static void fireBullet(Entity shooter) {
        Level level = shooter.level();
        if (level.isClientSide()) {
            return;
        }
        Projectile bullet = AMG26AIProcedure.createBullet(level, shooter);
        Vec3 look = shooter.getLookAngle();
        double forwardOffset = 1.2;
        double verticalOffset = 0.0;
        Vec3 spawnPos = shooter.getEyePosition().add(look.scale(forwardOffset)).add(0.0, verticalOffset, 0.0);
        bullet.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
        float speed = 4.4f;
        bullet.shoot(look.x, look.y, look.z, speed, 0.0f);
        Vec3 vel = bullet.getDeltaMovement();
        float yaw = (float)(Math.atan2(vel.z, vel.x) * 57.29577951308232) - 90.0f;
        float pitch = (float)(-(Math.atan2(vel.y, Math.sqrt(vel.x * vel.x + vel.z * vel.z)) * 57.29577951308232));
        bullet.setYRot(yaw);
        bullet.setXRot(pitch);
        bullet.yRotO = yaw;
        bullet.xRotO = pitch;
        level.addFreshEntity((Entity)bullet);
        SoundUtils.playServerSound(level, ResourceLocation.parse((String)"fsa:mg15_shoot"), shooter.position(), 1.0f, 1.0f);
        shootTimer = firerate;
    }

    private static Projectile createBullet(Level level, Entity shooter) {
        Bullet01Entity bullet = new Bullet01Entity((EntityType)FsaModEntities.BULLET_01.get(), level){

            public byte getPierceLevel() {
                return 0;
            }

            @Override
            protected void doKnockback(LivingEntity target, DamageSource source) {
                double resistance = target.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE);
                double strength = Math.max(0.0, 1.0 - resistance);
                Vec3 push = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale(0.6 * strength);
                if (push.lengthSqr() > 0.0) {
                    target.push(push.x, 0.1, push.z);
                }
            }
        };
        bullet.setOwner(shooter);
        bullet.setBaseDamage(5.0);
        bullet.setSilent(true);
        return bullet;
    }
}

