/*
 * Decompiled with CFR 0.152.
 */
package net.meowratic_works.fsa.procedures;

import java.util.Optional;
import java.util.UUID;
import net.meowratic_works.fsa.entity.TurretEntity;
import net.meowratic_works.fsa.utils.SoundUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber
public class OnRightClickTurretProcedure {
    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        Entity entity = event.getTarget();
        if (!(entity instanceof TurretEntity)) {
            return;
        }
        TurretEntity turret = (TurretEntity)entity;
        CompoundTag data = player2.getPersistentData();
        if (player2.isCrouching()) {
            boolean isOn = (Boolean)turret.getEntityData().get(TurretEntity.IS_ON);
            float battery = ((Float)turret.getEntityData().get(TurretEntity.BATTERY)).floatValue();
            boolean voiceOn = turret.HAS_SARA;
            if (!isOn && battery <= 0.0f && voiceOn) {
                SoundUtils.playServerSound(turret.level(), ResourceLocation.parse((String)"fsa:sara_low_battery"), turret.position(), 1.0f, 1.0f);
                event.setCanceled(true);
                return;
            }
            boolean newState = !isOn;
            turret.getEntityData().set(TurretEntity.IS_ON, (Object)newState);
            if (voiceOn) {
                SoundUtils.playServerSound(turret.level(), ResourceLocation.parse((String)(newState ? "fsa:sara_system_online" : "fsa:sara_system_offline")), turret.position(), 1.0f, 1.0f);
            }
            return;
        }
        if (data.hasUUID("controlled_turret")) {
            UUID oldUUID = data.getUUID("controlled_turret");
            for (Entity e : player2.level().getEntities((Entity)player2, player2.getBoundingBox().inflate(128.0))) {
                TurretEntity oldTurret;
                if (!(e instanceof TurretEntity) || !(oldTurret = (TurretEntity)e).getUUID().equals(oldUUID)) continue;
                oldTurret.getEntityData().set(TurretEntity.CONTROLLING_PLAYER, Optional.empty());
                break;
            }
        }
        data.putUUID("controlled_turret", turret.getUUID());
        turret.getEntityData().set(TurretEntity.CONTROLLING_PLAYER, Optional.of(player2.getUUID()));
    }
}

