/*
 * Decompiled with CFR 0.152.
 */
package net.meowratic_works.fsa.turret.upgrades;

import net.meowratic_works.fsa.entity.AC25Entity;
import net.meowratic_works.fsa.entity.AC26Entity;
import net.meowratic_works.fsa.entity.AMG26Entity;
import net.meowratic_works.fsa.entity.ATC24Entity;
import net.meowratic_works.fsa.turret.upgrades.TurretUpgrade;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class ShieldUpgrade
implements TurretUpgrade {
    public static final ResourceLocation TURRET_HEALTH_MOD = ResourceLocation.parse((String)"fsa:turret_health_upgrade");
    public static final ResourceLocation TURRET_ARMOR_MOD = ResourceLocation.parse((String)"fsa:turret_armor_upgrade");

    @Override
    public void apply(LivingEntity turret) {
        AttributeInstance health = turret.getAttribute(Attributes.MAX_HEALTH);
        AttributeInstance armor = turret.getAttribute(Attributes.ARMOR);
        if (health != null) {
            health.addPermanentModifier(new AttributeModifier(TURRET_HEALTH_MOD, 20.0, AttributeModifier.Operation.ADD_VALUE));
        }
        if (armor != null) {
            armor.addPermanentModifier(new AttributeModifier(TURRET_ARMOR_MOD, 6.0, AttributeModifier.Operation.ADD_VALUE));
        }
        if (turret instanceof AMG26Entity) {
            AMG26Entity amg = (AMG26Entity)turret;
            amg.getEntityData().set(AMG26Entity.HAS_SHIELD_UPGRADE, (Object)true);
        }
        if (turret instanceof AC25Entity) {
            AC25Entity amg2 = (AC25Entity)turret;
            amg2.getEntityData().set(AC25Entity.HAS_SHIELD_UPGRADE, (Object)true);
        }
        if (turret instanceof AC26Entity) {
            AC26Entity amg3 = (AC26Entity)turret;
            amg3.getEntityData().set(AC25Entity.HAS_SHIELD_UPGRADE, (Object)true);
        }
        if (turret instanceof ATC24Entity) {
            ATC24Entity amg4 = (ATC24Entity)turret;
            amg4.getEntityData().set(AC25Entity.HAS_SHIELD_UPGRADE, (Object)true);
        }
    }

    @Override
    public void remove(LivingEntity turret) {
        AttributeInstance health = turret.getAttribute(Attributes.MAX_HEALTH);
        AttributeInstance armor = turret.getAttribute(Attributes.ARMOR);
        if (health != null) {
            health.removeModifier(TURRET_HEALTH_MOD);
        }
        if (armor != null) {
            armor.removeModifier(TURRET_ARMOR_MOD);
        }
        if (turret instanceof AMG26Entity) {
            AMG26Entity amg = (AMG26Entity)turret;
            amg.getEntityData().set(AMG26Entity.HAS_SHIELD_UPGRADE, (Object)false);
        }
        if (turret instanceof AC25Entity) {
            AC25Entity amg2 = (AC25Entity)turret;
            amg2.getEntityData().set(AC25Entity.HAS_SHIELD_UPGRADE, (Object)false);
        }
        if (turret instanceof AC26Entity) {
            AC26Entity amg3 = (AC26Entity)turret;
            amg3.getEntityData().set(AC25Entity.HAS_SHIELD_UPGRADE, (Object)false);
        }
        if (turret instanceof ATC24Entity) {
            ATC24Entity amg4 = (ATC24Entity)turret;
            amg4.getEntityData().set(AC25Entity.HAS_SHIELD_UPGRADE, (Object)false);
        }
        turret.setHealth(Math.min(turret.getHealth(), turret.getMaxHealth()));
    }
}

