/*
 * Decompiled with CFR 0.152.
 */
package net.meowratic_works.fsa.utils;

import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class InventoryUtils {
    public int getTotal(Entity entity, Item item) {
        if (entity == null || item == null) {
            return 0;
        }
        int total = 0;
        Object object = entity.getCapability(Capabilities.ItemHandler.ENTITY, null);
        if (object instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable handler = (IItemHandlerModifiable)object;
            for (int slot = 1; slot <= 12; ++slot) {
                ItemStack stack = handler.getStackInSlot(slot);
                if (stack.isEmpty() || stack.getItem() != item) continue;
                total += stack.getCount();
            }
        }
        return total;
    }

    public void extract(Entity entity, Item item, int amount) {
        if (entity == null || item == null || amount <= 0) {
            return;
        }
        Object object = entity.getCapability(Capabilities.ItemHandler.ENTITY, null);
        if (object instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable handler = (IItemHandlerModifiable)object;
            int remaining = amount;
            for (int slot = 1; slot <= 12 && remaining > 0; ++slot) {
                ItemStack stack = handler.getStackInSlot(slot);
                if (stack.isEmpty() || stack.getItem() != item) continue;
                int remove = Math.min(stack.getCount(), remaining);
                stack.shrink(remove);
                remaining -= remove;
                if (!stack.isEmpty()) continue;
                handler.setStackInSlot(slot, ItemStack.EMPTY);
            }
        }
    }

    public static boolean hasItemInSlot(Entity entity, int slot, Item item) {
        if (entity == null || item == null) {
            return false;
        }
        Object object = entity.getCapability(Capabilities.ItemHandler.ENTITY, null);
        if (object instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable handler = (IItemHandlerModifiable)object;
            if (slot < 0 || slot >= handler.getSlots()) {
                return false;
            }
            ItemStack stack = handler.getStackInSlot(slot);
            return !stack.isEmpty() && stack.getItem() == item;
        }
        return false;
    }

    public static boolean hasItemInSlot(Entity entity, int slot, String itemId) {
        if (entity == null || itemId == null) {
            return false;
        }
        ResourceLocation id = ResourceLocation.tryParse((String)itemId);
        if (id == null) {
            return false;
        }
        Item targetItem = (Item)BuiltInRegistries.ITEM.get(id);
        if (targetItem == null) {
            return false;
        }
        return InventoryUtils.hasItemInSlot(entity, slot, targetItem);
    }

    @Nullable
    public static ItemStack getItemInSlot(Entity entity, int slot) {
        if (entity == null) {
            return ItemStack.EMPTY;
        }
        Object object = entity.getCapability(Capabilities.ItemHandler.ENTITY, null);
        if (object instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable handler = (IItemHandlerModifiable)object;
            if (slot < 0 || slot >= handler.getSlots()) {
                return ItemStack.EMPTY;
            }
            return handler.getStackInSlot(slot);
        }
        return ItemStack.EMPTY;
    }
}

