/*
 * Decompiled with CFR 0.152.
 */
package net.meowratic_works.fsa.utils;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class ItemInventoryUtils {
    public static boolean isItemInSlot(ItemStack bag, int slot, String itemId) {
        if (bag.isEmpty()) {
            return false;
        }
        ResourceLocation targetId = ResourceLocation.tryParse((String)itemId);
        if (targetId == null) {
            return false;
        }
        IItemHandler handler = (IItemHandler)bag.getCapability(Capabilities.ItemHandler.ITEM, null);
        if (handler == null) {
            return false;
        }
        if (slot < 0 || slot >= handler.getSlots()) {
            return false;
        }
        ItemStack stack = handler.getStackInSlot(slot);
        if (stack.isEmpty()) {
            return false;
        }
        return targetId.equals((Object)BuiltInRegistries.ITEM.getKey((Object)stack.getItem()));
    }

    public static ItemStack getItemInSlot(ItemStack bag, int slot) {
        if (bag == null || bag.isEmpty()) {
            return ItemStack.EMPTY;
        }
        IItemHandler handler = (IItemHandler)bag.getCapability(Capabilities.ItemHandler.ITEM, null);
        if (handler == null) {
            return ItemStack.EMPTY;
        }
        if (slot < 0 || slot >= handler.getSlots()) {
            return ItemStack.EMPTY;
        }
        return handler.getStackInSlot(slot).copy();
    }
}

