/*
 * Decompiled with CFR 0.152.
 */
package net.meowratic_works.fsa.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class ParticleUtil {
    public static void shellClient(Entity entity, double forward, double right, double up, String particleId, float velForward, float velRight, float velUp) {
        Vec3 vec3;
        if (entity == null) {
            return;
        }
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        ResourceLocation id = ResourceLocation.tryParse((String)particleId);
        if (id == null) {
            return;
        }
        ParticleType type = (ParticleType)BuiltInRegistries.PARTICLE_TYPE.get(id);
        if (!(type instanceof SimpleParticleType)) {
            return;
        }
        SimpleParticleType simple = (SimpleParticleType)type;
        Vec3 fwd = entity.getLookAngle().normalize();
        Vec3 worldUp = Math.abs(fwd.y) > 0.98 ? new Vec3(1.0, 0.0, 0.0) : new Vec3(0.0, 1.0, 0.0);
        Vec3 rightVec = fwd.cross(worldUp).normalize();
        Vec3 upVec = rightVec.cross(fwd).normalize();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            vec3 = living.getEyePosition();
        } else {
            vec3 = entity.position().add(0.0, (double)entity.getBbHeight() * 0.5, 0.0);
        }
        Vec3 origin = vec3;
        origin = origin.add(fwd.scale(forward)).add(rightVec.scale(right)).add(upVec.scale(up));
        Vec3 velocity = fwd.scale((double)velForward).add(rightVec.scale((double)velRight)).add(upVec.scale((double)velUp));
        level.addParticle((ParticleOptions)simple, origin.x, origin.y, origin.z, velocity.x, velocity.y, velocity.z);
    }
}

