/*
 * Decompiled with CFR 0.152.
 */
package net.meowratic_works.fsa.utils;

import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;

public final class RandomUtils {
    private static final RandomSource SHARED = RandomSource.create();

    private RandomUtils() {
    }

    public static boolean chance(Level level, float chance) {
        return level.random.nextFloat() < chance;
    }

    public static boolean percent(Level level, int percent) {
        return level.random.nextInt(100) < percent;
    }

    public static boolean oneIn(Level level, int n) {
        return n > 0 && level.random.nextInt(n) == 0;
    }

    public static int range(Level level, int min, int max) {
        if (min >= max) {
            return min;
        }
        return level.random.nextInt(max - min + 1) + min;
    }

    public static float range(Level level, float min, float max) {
        return min + level.random.nextFloat() * (max - min);
    }

    public static boolean weighted(Level level, int weight, int total) {
        return level.random.nextInt(total) < weight;
    }

    public static int randomSign(Level level) {
        return level.random.nextBoolean() ? 1 : -1;
    }

    public static boolean chance(float chance) {
        return SHARED.nextFloat() < chance;
    }
}

