/*
 * Decompiled with CFR 0.152.
 */
package com.kaos.kaosmodu.client;

import com.kaos.kaosmodu.network.NetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="kaosmodu", value={Dist.CLIENT})
public class ClientChaosEvents {
    @SubscribeEvent
    public static void onComputeFov(ViewportEvent.ComputeFov event) {
        if (NetworkHandler.isEffectActive("fov_crazy")) {
            float time = (float)Minecraft.getInstance().level.getGameTime() / 5.0f;
            event.setFOV(event.getFOV() + (double)((float)Math.sin(time) * 40.0f));
        }
        if (NetworkHandler.isEffectActive("fov_narrow")) {
            event.setFOV(30.0);
        }
        if (NetworkHandler.isEffectActive("fov_wide")) {
            event.setFOV(150.0);
        }
    }

    @SubscribeEvent
    public static void onComputeCameraAngles(ViewportEvent.ComputeCameraAngles event) {
        float time;
        if (NetworkHandler.isEffectActive("screen_flip")) {
            event.setRoll(180.0f);
        }
        if (NetworkHandler.isEffectActive("screen_side_shift")) {
            time = (float)Minecraft.getInstance().level.getGameTime() / 2.0f;
            event.setYaw(event.getYaw() + (float)Math.sin(time) * 30.0f);
        }
        if (NetworkHandler.isEffectActive("kamera_spin")) {
            time = (float)Minecraft.getInstance().level.getGameTime() * 10.0f;
            event.setYaw(event.getYaw() + time);
        }
        if (NetworkHandler.isEffectActive("screen_shake")) {
            time = Minecraft.getInstance().level.getGameTime();
            event.setPitch(event.getPitch() + (float)Math.sin(time * 2.0f) * 5.0f);
            event.setYaw(event.getYaw() + (float)Math.cos(time * 2.5f) * 5.0f);
        }
        if (NetworkHandler.isEffectActive("camera_rewind") && Minecraft.getInstance().level.getGameTime() % 40L == 0L) {
            event.setYaw(event.getYaw() + 180.0f);
        }
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && NetworkHandler.isEffectActive("reverse_controls")) {
            mc.player.input.forwardImpulse *= -1.0f;
            mc.player.input.leftImpulse *= -1.0f;
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        if (event.getEntity().level().isClientSide && event.getEntity() == Minecraft.getInstance().player && NetworkHandler.isEffectActive("icy_feet") && event.getEntity().onGround() && event.getEntity().getDeltaMovement().horizontalDistanceSqr() > 0.001) {
            Vec3 movement = event.getEntity().getDeltaMovement();
            event.getEntity().setDeltaMovement(new Vec3(movement.x * 1.05, movement.y, movement.z * 1.05));
        }
    }

    @SubscribeEvent
    public static void onRenderGui(RenderGuiEvent.Post event) {
        GuiGraphics graphics = event.getGuiGraphics();
        int width = graphics.guiWidth();
        Minecraft mc = Minecraft.getInstance();
        if (NetworkHandler.isEffectActive("instant_blackout")) {
            float time = (float)Minecraft.getInstance().level.getGameTime() / 10.0f;
            float alpha = (float)(Math.sin(time) * 0.5 + 0.5);
            int color = (int)(alpha * 255.0f) << 24;
            graphics.fill(0, 0, graphics.guiWidth(), graphics.guiHeight(), color);
        }
        if (NetworkHandler.isEffectActive("silence")) {
            Minecraft.getInstance().getSoundManager().stop();
        }
        if (NetworkHandler.isEffectActive("extreme_gamma")) {
            graphics.fill(0, 0, graphics.guiWidth(), graphics.guiHeight(), -1426063361);
        }
        if (NetworkHandler.isEffectActive("color_invert")) {
            graphics.fill(0, 0, graphics.guiWidth(), graphics.guiHeight(), 0x33FFFFFF);
        }
        if (NetworkHandler.isEffectActive("camera_stuck")) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException time) {
                // empty catch block
            }
        }
        if (NetworkHandler.isEffectActive("screen_blink") && Minecraft.getInstance().level.getGameTime() % 40L < 5L) {
            graphics.fill(0, 0, graphics.guiWidth(), graphics.guiHeight(), -16777216);
        }
        if (NetworkHandler.isEffectActive("flashbang")) {
            graphics.fill(0, 0, graphics.guiWidth(), graphics.guiHeight(), -285212673);
        }
        if (NetworkHandler.isEffectActive("sky_flicker") && Minecraft.getInstance().level.getGameTime() % 10L < 5L) {
            graphics.fill(0, 0, graphics.guiWidth(), graphics.guiHeight(), 0x66FFFFFF);
        }
        if (NetworkHandler.isEffectActive("sky_glitch") && Minecraft.getInstance().level.getGameTime() % 4L == 0L) {
            graphics.fill(0, 0, graphics.guiWidth(), graphics.guiHeight(), 0x4400FF00);
        }
        if (NetworkHandler.cooldownTotal > 0) {
            int barWidth = 180;
            int barHeight = 12;
            int x = (width - barWidth) / 2;
            int y = 5;
            float progress = (float)NetworkHandler.cooldownRemaining / (float)NetworkHandler.cooldownTotal;
            int fillWidth = (int)((float)barWidth * progress);
            graphics.fill(x - 2, y - 2, x + barWidth + 2, y + barHeight + 2, -872415232);
            graphics.fill(x, y, x + barWidth, y + barHeight, -14540254);
            graphics.fill(x, y, x + fillWidth, y + barHeight, -16720385);
            MutableComponent text = Component.translatable((String)"kaosmodu.hud.next_chaos", (Object[])new Object[]{NetworkHandler.cooldownRemaining / 20});
            graphics.drawCenteredString(mc.font, (Component)text, width / 2, y + 2, -1);
        }
        int yOffsetForEvents = 10;
        for (NetworkHandler.ActiveEventInfo activeEvent : NetworkHandler.activeEvents) {
            MutableComponent text = Component.translatable((String)"kaosmodu.hud.active_event", (Object[])new Object[]{Component.translatable((String)activeEvent.name()), activeEvent.remainingTicks() / 20});
            int textWidth = mc.font.width((FormattedText)text);
            int boxWidth = textWidth + 12;
            int boxHeight = 16;
            int x = width - boxWidth - 10;
            graphics.fill(x, yOffsetForEvents, x + boxWidth, yOffsetForEvents + boxHeight, -2013265920);
            graphics.renderOutline(x, yOffsetForEvents, boxWidth, boxHeight, -43691);
            graphics.drawString(mc.font, (Component)text, x + 6, yOffsetForEvents + 4, -1);
            yOffsetForEvents += boxHeight + 4;
        }
    }
}

