/*
 * Decompiled with CFR 0.152.
 */
package com.kaos.kaosmodu.commands;

import com.kaos.kaosmodu.KaosModu;
import com.kaos.kaosmodu.events.AbstractChaosEvent;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class ChaosCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"chaos").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"trigger").then(Commands.argument((String)"event", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            KaosModu.chaosManager.getAllEvents().forEach(e -> builder.suggest(e.getId()));
            return builder.buildFuture();
        }).executes(context -> {
            String eventId = StringArgumentType.getString((CommandContext)context, (String)"event");
            AbstractChaosEvent event = KaosModu.chaosManager.getEventById(eventId);
            if (event != null) {
                KaosModu.chaosManager.triggerEventGlobal(event, ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayers());
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"kaosmodu.command.trigger.success", (Object[])new Object[]{Component.translatable((String)event.getName())}), true);
            } else {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"kaosmodu.command.trigger.fail"));
            }
            return 1;
        })))).then(Commands.literal((String)"interval").then(Commands.argument((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            int seconds = IntegerArgumentType.getInteger((CommandContext)context, (String)"seconds");
            KaosModu.chaosManager.setCooldownInterval(seconds);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"kaosmodu.command.cooldown.success", (Object[])new Object[]{seconds}), true);
            return 1;
        })))).then(Commands.literal((String)"list").executes(context -> {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"kaosmodu.command.list.header"), false);
            KaosModu.chaosManager.getAllEvents().forEach(e -> ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"kaosmodu.command.list.item", (Object[])new Object[]{e.getId(), Component.translatable((String)e.getName())}), false));
            return 1;
        }))).then(Commands.literal((String)"clear").executes(context -> {
            KaosModu.chaosManager.stopAllEventsGlobal(((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayers());
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"kaosmodu.command.stop.success"), true);
            return 1;
        }))).then(Commands.literal((String)"skip").executes(context -> {
            KaosModu.chaosManager.skipCycle(((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayers());
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"kaosmodu.command.skip.success"), true);
            return 1;
        }))).then(Commands.literal((String)"enable").executes(context -> {
            KaosModu.chaosManager.setGameActive(true, ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayers());
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"kaosmodu.command.start.success"), true);
            return 1;
        }))).then(Commands.literal((String)"disable").executes(context -> {
            KaosModu.chaosManager.setGameActive(false, ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayers());
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"kaosmodu.command.stop.msg"), true);
            return 1;
        })));
    }
}

