/*
 * Decompiled with CFR 0.152.
 */
package com.kaos.kaosmodu.core;

import com.kaos.kaosmodu.KaosModu;
import com.kaos.kaosmodu.events.AbstractChaosEvent;
import com.kaos.kaosmodu.network.ChaosSyncPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class ChaosManager {
    private int cooldownIntervalTicks = 1200;
    private int cooldownRemainingTicks = 1200;
    private boolean isGameActive = false;
    private final List<ActiveChaosInstance> activeInstances = new CopyOnWriteArrayList<ActiveChaosInstance>();
    private final List<AbstractChaosEvent> allEvents = new ArrayList<AbstractChaosEvent>();
    private final Random random = new Random();

    public void setGameActive(boolean active, List<ServerPlayer> players) {
        this.isGameActive = active;
        if (!active) {
            this.stopAllEventsGlobal(players);
        } else {
            this.cooldownRemainingTicks = this.cooldownIntervalTicks;
        }
    }

    public boolean isGameActive() {
        return this.isGameActive;
    }

    public void stopAllEventsGlobal(List<ServerPlayer> players) {
        for (ActiveChaosInstance instance : this.activeInstances) {
            for (ServerPlayer player : players) {
                instance.event.onStop(player);
            }
        }
        this.activeInstances.clear();
        this.cooldownRemainingTicks = this.cooldownIntervalTicks;
        for (ServerPlayer player : players) {
            player.sendSystemMessage((Component)Component.translatable((String)"kaosmodu.game.stopped"));
        }
    }

    public void registerEvent(AbstractChaosEvent event) {
        this.allEvents.add(event);
    }

    public List<AbstractChaosEvent> getAllEvents() {
        return this.allEvents;
    }

    public AbstractChaosEvent getEventById(String id) {
        return this.allEvents.stream().filter(e -> e.getId().equals(id)).findFirst().orElse(null);
    }

    public void setCooldownInterval(int seconds) {
        this.cooldownIntervalTicks = seconds * 20;
        if (this.cooldownRemainingTicks > this.cooldownIntervalTicks) {
            this.cooldownRemainingTicks = this.cooldownIntervalTicks;
        }
    }

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Post event) {
        if (!this.isGameActive) {
            if (event.getServer().getTickCount() % 20 == 0) {
                this.syncToAll(event.getServer().getPlayerList().getPlayers());
            }
            return;
        }
        --this.cooldownRemainingTicks;
        if (this.cooldownRemainingTicks <= 0) {
            this.cooldownRemainingTicks = this.cooldownIntervalTicks;
            this.startNewChaosTrigger(event.getServer().getPlayerList().getPlayers());
        }
        List players = event.getServer().getPlayerList().getPlayers();
        ArrayList<ActiveChaosInstance> toRemove = new ArrayList<ActiveChaosInstance>();
        for (ActiveChaosInstance instance : this.activeInstances) {
            --instance.remainingTicks;
            for (ServerPlayer player : players) {
                instance.event.onTick(player);
            }
            if (instance.remainingTicks > 0) continue;
            for (ServerPlayer player : players) {
                instance.event.onStop(player);
            }
            toRemove.add(instance);
        }
        if (!toRemove.isEmpty()) {
            this.activeInstances.removeAll(toRemove);
        }
        if (event.getServer().getTickCount() % 10 == 0) {
            this.syncToAll(players);
        }
    }

    private void syncToAll(List<ServerPlayer> players) {
        List<String> names = this.activeInstances.stream().map(i -> i.event.getName()).toList();
        List<Integer> ticks = this.activeInstances.stream().map(i -> i.remainingTicks).toList();
        ChaosSyncPacket packet = new ChaosSyncPacket(this.cooldownRemainingTicks, this.cooldownIntervalTicks, names, ticks);
        for (ServerPlayer player : players) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void skipCycle(List<ServerPlayer> players) {
        this.cooldownRemainingTicks = 0;
    }

    private void startNewChaosTrigger(List<ServerPlayer> players) {
        AbstractChaosEvent omega;
        if (this.allEvents.isEmpty()) {
            return;
        }
        if (this.random.nextInt(500) == 0 && (omega = this.getEventById("omega_chaos")) != null) {
            this.triggerEventGlobal(omega, players);
            return;
        }
        AbstractChaosEvent event = this.allEvents.get(this.random.nextInt(this.allEvents.size()));
        while (event != null && event.getId().equals("omega_chaos")) {
            event = this.allEvents.get(this.random.nextInt(this.allEvents.size()));
        }
        if (event != null) {
            this.triggerEventGlobal(event, players);
        }
    }

    public void triggerEventGlobal(AbstractChaosEvent event, List<ServerPlayer> players) {
        int duration = event.isOneTime() ? 1 : 200 + this.random.nextInt(701);
        this.activeInstances.add(new ActiveChaosInstance(event, duration));
        for (ServerPlayer player : players) {
            event.onStart(player);
        }
        KaosModu.LOGGER.info("Chaos triggered globally! Event: {}", (Object)event.getName());
        for (ServerPlayer player : players) {
            player.sendSystemMessage((Component)Component.translatable((String)"kaosmodu.event.triggered", (Object[])new Object[]{Component.translatable((String)event.getName())}));
        }
    }

    public void triggerRandomEventGlobal(List<ServerPlayer> players) {
        if (!this.allEvents.isEmpty()) {
            AbstractChaosEvent event = this.allEvents.get(this.random.nextInt(this.allEvents.size()));
            this.triggerEventGlobal(event, players);
        }
    }

    public void triggerRandomEvent(ServerPlayer player) {
        this.triggerRandomEventGlobal(player.server.getPlayerList().getPlayers());
    }

    public void stopAllEventsForPlayer(ServerPlayer player) {
        this.stopAllEventsGlobal(player.server.getPlayerList().getPlayers());
    }

    public static class ActiveChaosInstance {
        public final AbstractChaosEvent event;
        public int remainingTicks;

        public ActiveChaosInstance(AbstractChaosEvent event, int remainingTicks) {
            this.event = event;
            this.remainingTicks = remainingTicks;
        }
    }
}

