/*
 * Decompiled with CFR 0.152.
 */
package com.kaos.kaosmodu.events;

import com.kaos.kaosmodu.network.ChaosEffectPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class AbstractChaosEvent {
    private final String id;
    private final EventType type;

    public AbstractChaosEvent(String id, EventType type) {
        this.id = id;
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return "kaosmodu.event." + this.id;
    }

    public EventType getType() {
        return this.type;
    }

    public boolean isOneTime() {
        return false;
    }

    public abstract void onStart(ServerPlayer var1);

    public void onTick(ServerPlayer player) {
    }

    public void onStop(ServerPlayer player) {
    }

    protected void sendToClient(ServerPlayer player, String effectId, boolean active) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ChaosEffectPacket(effectId, active), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static enum EventType {
        BAD,
        GOOD,
        RARE,
        LEGENDARY;

    }
}

