/*
 * Decompiled with CFR 0.152.
 */
package com.kaos.kaosmodu.events.impl;

import com.kaos.kaosmodu.events.AbstractChaosEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.phys.Vec3;

public class CircleTntEvent
extends AbstractChaosEvent {
    public CircleTntEvent() {
        super("circle_tnt", AbstractChaosEvent.EventType.BAD);
    }

    @Override
    public void onStart(ServerPlayer player) {
    }

    @Override
    public void onTick(ServerPlayer player) {
        if (player.level().getGameTime() % 100L == 0L) {
            Vec3 center = player.position();
            int amount = 8;
            double radius = 5.0;
            for (int i = 0; i < amount; ++i) {
                double angle = (double)i * (Math.PI * 2 / (double)amount);
                double x = center.x + radius * Math.cos(angle);
                double z = center.z + radius * Math.sin(angle);
                PrimedTnt tnt = (PrimedTnt)EntityType.TNT.create(player.level());
                if (tnt == null) continue;
                tnt.moveTo(x, center.y + 1.0, z);
                tnt.setFuse(40);
                player.level().addFreshEntity((Entity)tnt);
            }
        }
    }

    @Override
    public void onStop(ServerPlayer player) {
    }
}

