/*
 * Decompiled with CFR 0.152.
 */
package com.kaos.kaosmodu.events.impl;

import com.kaos.kaosmodu.events.AbstractChaosEvent;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;

public class EchoMovementEvent
extends AbstractChaosEvent {
    private final Queue<Vec3> history = new LinkedList<Vec3>();

    public EchoMovementEvent() {
        super("echo_movement", AbstractChaosEvent.EventType.BAD);
    }

    @Override
    public void onStart(ServerPlayer player) {
        this.history.clear();
    }

    @Override
    public void onTick(ServerPlayer player) {
        this.history.add(player.getDeltaMovement());
        if (this.history.size() > 60) {
            Vec3 oldVel = this.history.poll();
            if (player.level().getGameTime() % 20L == 0L) {
                player.setDeltaMovement(oldVel);
                player.hurtMarked = true;
            }
        }
    }

    @Override
    public void onStop(ServerPlayer player) {
        this.history.clear();
    }
}

