/*
 * Decompiled with CFR 0.152.
 */
package com.kaos.kaosmodu.events.impl;

import com.kaos.kaosmodu.events.AbstractChaosEvent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;

public class EffectEchoEvent
extends AbstractChaosEvent {
    private final Map<Holder<MobEffect>, Integer> lastAmplifiers = new HashMap<Holder<MobEffect>, Integer>();

    public EffectEchoEvent() {
        super("effect_echo", AbstractChaosEvent.EventType.BAD);
    }

    @Override
    public void onStart(ServerPlayer player) {
        this.lastAmplifiers.clear();
    }

    @Override
    public void onTick(ServerPlayer player) {
        for (MobEffectInstance mobEffectInstance : player.getActiveEffects()) {
            this.lastAmplifiers.put((Holder<MobEffect>)mobEffectInstance.getEffect(), mobEffectInstance.getAmplifier());
        }
        if (player.level().getGameTime() % 40L == 0L) {
            for (Map.Entry entry : new HashMap<Holder<MobEffect>, Integer>(this.lastAmplifiers).entrySet()) {
                if (player.hasEffect((Holder)entry.getKey())) continue;
                player.addEffect(new MobEffectInstance((Holder)entry.getKey(), 200, ((Integer)entry.getValue()).intValue()));
            }
        }
    }

    @Override
    public void onStop(ServerPlayer player) {
        this.lastAmplifiers.clear();
    }
}

