/*
 * Decompiled with CFR 0.152.
 */
package com.kaos.kaosmodu.events.impl;

import com.kaos.kaosmodu.events.AbstractChaosEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class FakeItemsEvent
extends AbstractChaosEvent {
    private final List<ItemEntity> fakeItems = new ArrayList<ItemEntity>();

    public FakeItemsEvent() {
        super("fake_items", AbstractChaosEvent.EventType.BAD);
    }

    @Override
    public void onStart(ServerPlayer player) {
        this.fakeItems.clear();
        for (int i = 0; i < 3; ++i) {
            ItemEntity item = new ItemEntity(player.level(), player.getX() + (double)player.getRandom().nextInt(6) - 3.0, player.getY() + 1.0, player.getZ() + (double)player.getRandom().nextInt(6) - 3.0, new ItemStack((ItemLike)Items.DIAMOND));
            item.setPickUpDelay(Short.MAX_VALUE);
            player.level().addFreshEntity((Entity)item);
            this.fakeItems.add(item);
        }
    }

    @Override
    public void onTick(ServerPlayer player) {
        this.fakeItems.removeIf(item -> {
            if (item.distanceToSqr((Entity)player) < 1.0) {
                item.discard();
                return true;
            }
            return !item.isAlive();
        });
    }

    @Override
    public void onStop(ServerPlayer player) {
        this.fakeItems.forEach(Entity::discard);
        this.fakeItems.clear();
    }
}

