/*
 * Decompiled with CFR 0.152.
 */
package com.kaos.kaosmodu.events.impl;

import com.kaos.kaosmodu.events.AbstractChaosEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;

public class FakeMobsEvent
extends AbstractChaosEvent {
    private final List<LivingEntity> fakeMobs = new ArrayList<LivingEntity>();

    public FakeMobsEvent() {
        super("fake_mobs", AbstractChaosEvent.EventType.BAD);
    }

    @Override
    public void onStart(ServerPlayer player) {
        this.fakeMobs.clear();
        ServerLevel level = player.serverLevel();
        for (int i = 0; i < 5; ++i) {
            Zombie fake = new Zombie(EntityType.ZOMBIE, (Level)level);
            fake.setPos(player.getX() + (double)player.getRandom().nextInt(10) - 5.0, player.getY(), player.getZ() + (double)player.getRandom().nextInt(10) - 5.0);
            fake.setCustomName((Component)Component.translatable((String)"kaosmodu.event.fake_mobs.name"));
            level.addFreshEntity((Entity)fake);
            this.fakeMobs.add((LivingEntity)fake);
        }
    }

    @Override
    public void onTick(ServerPlayer player) {
        this.fakeMobs.removeIf(entity -> {
            if (!entity.isAlive() || entity.hurtTime > 0) {
                player.serverLevel().sendParticles((ParticleOptions)ParticleTypes.POOF, entity.getX(), entity.getY() + 1.0, entity.getZ(), 10, 0.2, 0.2, 0.2, 0.0);
                entity.discard();
                return true;
            }
            return false;
        });
    }

    @Override
    public void onStop(ServerPlayer player) {
        this.fakeMobs.forEach(Entity2 -> Entity2.discard());
        this.fakeMobs.clear();
    }
}

