/*
 * Decompiled with CFR 0.152.
 */
package com.kaos.kaosmodu.events.impl;

import com.kaos.kaosmodu.events.AbstractChaosEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Blocks;

public class FakeWallsEvent
extends AbstractChaosEvent {
    private final List<BlockPos> barrierPositions = new ArrayList<BlockPos>();

    public FakeWallsEvent() {
        super("fake_walls", AbstractChaosEvent.EventType.BAD);
    }

    @Override
    public void onStart(ServerPlayer player) {
        this.barrierPositions.clear();
        BlockPos pos = player.blockPosition();
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                if (Math.abs(x) != 3 && Math.abs(z) != 3) continue;
                for (int y = 0; y < 3; ++y) {
                    BlockPos target = pos.offset(x, y, z);
                    if (!player.level().getBlockState(target).isAir()) continue;
                    player.level().setBlockAndUpdate(target, Blocks.BARRIER.defaultBlockState());
                    this.barrierPositions.add(target);
                }
            }
        }
    }

    @Override
    public void onTick(ServerPlayer player) {
    }

    @Override
    public void onStop(ServerPlayer player) {
        for (BlockPos pos : this.barrierPositions) {
            if (!player.level().getBlockState(pos).is(Blocks.BARRIER)) continue;
            player.level().setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        }
    }
}

