/*
 * Decompiled with CFR 0.152.
 */
package com.kaos.kaosmodu.events.impl;

import com.kaos.kaosmodu.events.AbstractChaosEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;

public class GhostPlayerEvent
extends AbstractChaosEvent {
    private Zombie ghost;

    public GhostPlayerEvent() {
        super("ghost_player", AbstractChaosEvent.EventType.BAD);
    }

    @Override
    public void onStart(ServerPlayer player) {
        this.ghost = new Zombie(EntityType.ZOMBIE, (Level)player.serverLevel());
        this.ghost.setPos(player.getX() + 5.0, player.getY(), player.getZ() + 5.0);
        this.ghost.setCustomName(player.getName());
        this.ghost.setNoAi(true);
        this.ghost.setInvulnerable(true);
        player.serverLevel().addFreshEntity((Entity)this.ghost);
    }

    @Override
    public void onTick(ServerPlayer player) {
        if (this.ghost != null && this.ghost.isAlive() && player.level().getGameTime() % 40L == 0L) {
            this.ghost.teleportTo(player.getX() + (double)player.getRandom().nextInt(20) - 10.0, player.getY(), player.getZ() + (double)player.getRandom().nextInt(20) - 10.0);
        }
    }

    @Override
    public void onStop(ServerPlayer player) {
        if (this.ghost != null) {
            this.ghost.discard();
        }
    }
}

