/*
 * Decompiled with CFR 0.152.
 */
package com.kaos.kaosmodu.events.impl;

import com.kaos.kaosmodu.events.AbstractChaosEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class GravityEvent
extends AbstractChaosEvent {
    private static final ResourceLocation GRAVITY_MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"kaosmodu", (String)"high_gravity");
    private final AttributeModifier modifier = new AttributeModifier(GRAVITY_MODIFIER_ID, 0.5, AttributeModifier.Operation.ADD_VALUE);

    public GravityEvent() {
        super("high_gravity", AbstractChaosEvent.EventType.BAD);
    }

    @Override
    public void onStart(ServerPlayer player) {
        AttributeInstance gravity = player.getAttribute(Attributes.GRAVITY);
        if (gravity != null && !gravity.hasModifier(GRAVITY_MODIFIER_ID)) {
            gravity.addTransientModifier(this.modifier);
        }
    }

    @Override
    public void onTick(ServerPlayer player) {
    }

    @Override
    public void onStop(ServerPlayer player) {
        AttributeInstance gravity = player.getAttribute(Attributes.GRAVITY);
        if (gravity != null) {
            gravity.removeModifier(GRAVITY_MODIFIER_ID);
        }
    }
}

