/*
 * Decompiled with CFR 0.152.
 */
package com.kaos.kaosmodu.events.impl;

import com.kaos.kaosmodu.events.AbstractChaosEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class GravityFlipEvent
extends AbstractChaosEvent {
    private static final ResourceLocation GRAVITY_FLIP_ID = ResourceLocation.fromNamespaceAndPath((String)"kaosmodu", (String)"gravity_flip");
    private final AttributeModifier modifier = new AttributeModifier(GRAVITY_FLIP_ID, -1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);

    public GravityFlipEvent() {
        super("gravity_flip", AbstractChaosEvent.EventType.BAD);
    }

    @Override
    public void onStart(ServerPlayer player) {
        AttributeInstance gravity = player.getAttribute(Attributes.GRAVITY);
        if (gravity != null && !gravity.hasModifier(GRAVITY_FLIP_ID)) {
            gravity.addTransientModifier(this.modifier);
        }
    }

    @Override
    public void onTick(ServerPlayer player) {
    }

    @Override
    public void onStop(ServerPlayer player) {
        AttributeInstance gravity = player.getAttribute(Attributes.GRAVITY);
        if (gravity != null) {
            gravity.removeModifier(GRAVITY_FLIP_ID);
        }
    }
}

