/*
 * Decompiled with CFR 0.152.
 */
package com.kaos.kaosmodu.events.impl;

import com.kaos.kaosmodu.events.AbstractChaosEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class GravityWaveEvent
extends AbstractChaosEvent {
    private static final ResourceLocation GRAVITY_WAVE_ID = ResourceLocation.fromNamespaceAndPath((String)"kaosmodu", (String)"gravity_wave");

    public GravityWaveEvent() {
        super("gravity_wave", AbstractChaosEvent.EventType.BAD);
    }

    @Override
    public void onStart(ServerPlayer player) {
    }

    @Override
    public void onTick(ServerPlayer player) {
        AttributeInstance gravity = player.getAttribute(Attributes.GRAVITY);
        if (gravity != null) {
            gravity.removeModifier(GRAVITY_WAVE_ID);
            double waveValue = Math.sin((double)player.level().getGameTime() / 10.0) * 0.5;
            AttributeModifier modifier = new AttributeModifier(GRAVITY_WAVE_ID, waveValue, AttributeModifier.Operation.ADD_VALUE);
            gravity.addTransientModifier(modifier);
        }
    }

    @Override
    public void onStop(ServerPlayer player) {
        AttributeInstance gravity = player.getAttribute(Attributes.GRAVITY);
        if (gravity != null) {
            gravity.removeModifier(GRAVITY_WAVE_ID);
        }
    }
}

