/*
 * Decompiled with CFR 0.152.
 */
package com.kaos.kaosmodu.events.impl;

import com.kaos.kaosmodu.events.AbstractChaosEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class ItemDisappearEvent
extends AbstractChaosEvent {
    private final Map<UUID, ItemStack> hiddenItems = new HashMap<UUID, ItemStack>();

    public ItemDisappearEvent() {
        super("item_disappear", AbstractChaosEvent.EventType.BAD);
    }

    @Override
    public void onStart(ServerPlayer player) {
    }

    @Override
    public void onTick(ServerPlayer player) {
        ItemStack stack;
        long time = player.level().getGameTime() % 200L;
        if (time == 0L) {
            ItemStack stack2 = player.getMainHandItem().copy();
            if (!stack2.isEmpty()) {
                this.hiddenItems.put(player.getUUID(), stack2);
                player.getMainHandItem().setCount(0);
            }
        } else if (time == 100L && (stack = this.hiddenItems.remove(player.getUUID())) != null) {
            player.getInventory().add(stack);
        }
    }

    @Override
    public void onStop(ServerPlayer player) {
        ItemStack stack = this.hiddenItems.remove(player.getUUID());
        if (stack != null) {
            player.getInventory().add(stack);
        }
    }
}

