/*
 * Decompiled with CFR 0.152.
 */
package com.kaos.kaosmodu.events.impl;

import com.kaos.kaosmodu.events.AbstractChaosEvent;
import net.minecraft.ChatFormatting;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;

public class MobColorEvent
extends AbstractChaosEvent {
    public MobColorEvent() {
        super("mob_color_change", AbstractChaosEvent.EventType.BAD);
    }

    @Override
    public void onStart(ServerPlayer player) {
    }

    @Override
    public void onTick(ServerPlayer player) {
        if (player.level().getGameTime() % 40L == 0L) {
            AABB area = player.getBoundingBox().inflate(15.0);
            ServerScoreboard scoreboard = player.getServer().getScoreboard();
            ChatFormatting[] colors = new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BLUE, ChatFormatting.GREEN, ChatFormatting.YELLOW, ChatFormatting.GOLD, ChatFormatting.AQUA};
            player.level().getEntitiesOfClass(LivingEntity.class, area, e -> e != player).forEach(arg_0 -> MobColorEvent.lambda$onTick$1(colors, player, (Scoreboard)scoreboard, arg_0));
        }
    }

    @Override
    public void onStop(ServerPlayer player) {
        AABB area = player.getBoundingBox().inflate(30.0);
        ServerScoreboard scoreboard = player.getServer().getScoreboard();
        player.level().getEntitiesOfClass(LivingEntity.class, area, e -> e != player).forEach(arg_0 -> MobColorEvent.lambda$onStop$3((Scoreboard)scoreboard, arg_0));
    }

    private static /* synthetic */ void lambda$onStop$3(Scoreboard scoreboard, LivingEntity entity) {
        entity.setGlowingTag(false);
        PlayerTeam team = scoreboard.getPlayersTeam(entity.getScoreboardName());
        if (team != null && team.getName().startsWith("kaos_")) {
            scoreboard.removePlayerFromTeam(entity.getScoreboardName(), team);
        }
    }

    private static /* synthetic */ void lambda$onTick$1(ChatFormatting[] colors, ServerPlayer player, Scoreboard scoreboard, LivingEntity entity) {
        ChatFormatting color = colors[player.getRandom().nextInt(colors.length)];
        String teamName = "kaos_" + color.getName();
        PlayerTeam team = scoreboard.getPlayerTeam(teamName);
        if (team == null) {
            team = scoreboard.addPlayerTeam(teamName);
            team.setColor(color);
        }
        scoreboard.addPlayerToTeam(entity.getScoreboardName(), team);
        entity.setGlowingTag(true);
    }
}

