/*
 * Decompiled with CFR 0.152.
 */
package com.kaos.kaosmodu.events.impl;

import com.kaos.kaosmodu.events.AbstractChaosEvent;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;

public class MobFakeDeathEvent
extends AbstractChaosEvent {
    public MobFakeDeathEvent() {
        super("mob_fake_death", AbstractChaosEvent.EventType.BAD);
    }

    @Override
    public void onStart(ServerPlayer player) {
    }

    @Override
    public void onTick(ServerPlayer player) {
        if (player.level().getGameTime() % 100L == 0L) {
            AABB area = player.getBoundingBox().inflate(15.0);
            player.level().getEntitiesOfClass(LivingEntity.class, area, e -> e != player).forEach(entity -> {
                ServerLevel level = (ServerLevel)entity.level();
                level.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, entity.getX(), entity.getY(), entity.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.GENERIC_DEATH, SoundSource.HOSTILE, 1.0f, 1.0f);
                entity.setInvisible(true);
            });
        } else if (player.level().getGameTime() % 100L == 40L) {
            AABB area = player.getBoundingBox().inflate(30.0);
            player.level().getEntitiesOfClass(LivingEntity.class, area, e -> e != player).forEach(entity -> entity.setInvisible(false));
        }
    }

    @Override
    public void onStop(ServerPlayer player) {
        AABB area = player.getBoundingBox().inflate(30.0);
        player.level().getEntitiesOfClass(LivingEntity.class, area, e -> e != player).forEach(entity -> entity.setInvisible(false));
    }
}

