/*
 * Decompiled with CFR 0.152.
 */
package com.kaos.kaosmodu.events.impl;

import com.kaos.kaosmodu.events.AbstractChaosEvent;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;

public class MobSkyFallEvent
extends AbstractChaosEvent {
    private final List<EntityType<? extends LivingEntity>> mobTypes = List.of(EntityType.ZOMBIE, EntityType.SKELETON, EntityType.CREEPER, EntityType.SPIDER);

    public MobSkyFallEvent() {
        super("mob_sky_fall", AbstractChaosEvent.EventType.BAD);
    }

    @Override
    public void onStart(ServerPlayer player) {
    }

    @Override
    public void onTick(ServerPlayer player) {
        if (player.level().getGameTime() % 40L == 0L) {
            BlockPos spawnPos = player.blockPosition().offset(player.getRandom().nextInt(11) - 5, 20, player.getRandom().nextInt(11) - 5);
            EntityType<? extends LivingEntity> type = this.mobTypes.get(player.getRandom().nextInt(this.mobTypes.size()));
            LivingEntity mob = (LivingEntity)type.create(player.level());
            if (mob != null) {
                mob.moveTo((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
                player.level().addFreshEntity((Entity)mob);
            }
        }
    }

    @Override
    public void onStop(ServerPlayer player) {
    }
}

