/*
 * Decompiled with CFR 0.152.
 */
package com.kaos.kaosmodu.events.impl;

import com.kaos.kaosmodu.events.AbstractChaosEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class MoonGravityEvent
extends AbstractChaosEvent {
    private static final ResourceLocation MOON_GRAVITY_ID = ResourceLocation.fromNamespaceAndPath((String)"kaosmodu", (String)"moon_gravity");
    private final AttributeModifier modifier = new AttributeModifier(MOON_GRAVITY_ID, -0.06, AttributeModifier.Operation.ADD_VALUE);

    public MoonGravityEvent() {
        super("moon_gravity", AbstractChaosEvent.EventType.BAD);
    }

    @Override
    public void onStart(ServerPlayer player) {
        AttributeInstance gravity = player.getAttribute(Attributes.GRAVITY);
        if (gravity != null && !gravity.hasModifier(MOON_GRAVITY_ID)) {
            gravity.addTransientModifier(this.modifier);
        }
    }

    @Override
    public void onTick(ServerPlayer player) {
    }

    @Override
    public void onStop(ServerPlayer player) {
        AttributeInstance gravity = player.getAttribute(Attributes.GRAVITY);
        if (gravity != null) {
            gravity.removeModifier(MOON_GRAVITY_ID);
        }
    }
}

