/*
 * Decompiled with CFR 0.152.
 */
package com.kaos.kaosmodu.events.impl;

import com.kaos.kaosmodu.events.AbstractChaosEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;

public class ParallelPlayerEvent
extends AbstractChaosEvent {
    private Zombie parallel;

    public ParallelPlayerEvent() {
        super("parallel_player", AbstractChaosEvent.EventType.BAD);
    }

    @Override
    public void onStart(ServerPlayer player) {
        this.parallel = new Zombie(EntityType.ZOMBIE, (Level)player.serverLevel());
        this.parallel.setPos(player.getX() + 1.0, player.getY(), player.getZ());
        this.parallel.setCustomName(player.getName());
        this.parallel.setNoAi(true);
        player.serverLevel().addFreshEntity((Entity)this.parallel);
    }

    @Override
    public void onTick(ServerPlayer player) {
        if (this.parallel != null && this.parallel.isAlive()) {
            this.parallel.teleportTo(player.getX() + 2.0, player.getY(), player.getZ() + 2.0);
            this.parallel.setYRot(player.getYRot());
            this.parallel.setXRot(player.getXRot());
        }
    }

    @Override
    public void onStop(ServerPlayer player) {
        if (this.parallel != null) {
            this.parallel.discard();
        }
    }
}

