/*
 * Decompiled with CFR 0.152.
 */
package com.kaos.kaosmodu.network;

import com.kaos.kaosmodu.network.ChaosEffectPacket;
import com.kaos.kaosmodu.network.ChaosSyncPacket;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class NetworkHandler {
    private static final Set<String> activeClientEffects = new HashSet<String>();
    public static int cooldownRemaining = 0;
    public static int cooldownTotal = 1200;
    public static List<ActiveEventInfo> activeEvents = new ArrayList<ActiveEventInfo>();

    public static void handleChaosEffect(ChaosEffectPacket data, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (data.active()) {
                activeClientEffects.add(data.effectId());
            } else {
                activeClientEffects.remove(data.effectId());
            }
        });
    }

    public static void handleChaosSync(ChaosSyncPacket data, IPayloadContext context) {
        context.enqueueWork(() -> {
            cooldownRemaining = data.cooldownRemaining();
            cooldownTotal = data.cooldownTotal();
            activeEvents.clear();
            if (data.eventNames().isEmpty()) {
                activeClientEffects.clear();
            }
            for (int i = 0; i < data.eventNames().size(); ++i) {
                activeEvents.add(new ActiveEventInfo(data.eventNames().get(i), data.eventTicks().get(i)));
            }
        });
    }

    public static boolean isEffectActive(String effectId) {
        return activeClientEffects.contains(effectId);
    }

    public static void clearEffects() {
        activeClientEffects.clear();
    }

    public record ActiveEventInfo(String name, int remainingTicks) {
    }
}

