/*
 * Decompiled with CFR 0.152.
 */
package com.jubitus.birds;

import com.jubitus.birds.client.config.BirdConfig;
import com.jubitus.birds.proxy.CommonProxy;
import com.jubitus.birds.species.DefaultSpeciesExtractor;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="jubitusbirds", name="Jubitus birds", version="1.0.3", guiFactory="com.jubitus.birds.client.gui.JubitusBirdsGuiFactory")
public class JubitusBirds {
    public static final Logger LOGGER = LogManager.getLogger((String)"Jubitus birds");
    @SidedProxy(clientSide="com.jubitus.birds.proxy.ClientProxy", serverSide="com.jubitus.birds.proxy.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOGGER.info("Hello From {}!", (Object)"Jubitus birds");
        this.deleteOldRootConfig(event);
        DefaultSpeciesExtractor.extractMissingDefaults(event);
        BirdConfig.reloadFromGuiConfig();
        proxy.preInit(event);
    }

    private void deleteOldRootConfig(FMLPreInitializationEvent event) {
        try {
            File configDir = event.getModConfigurationDirectory();
            Path oldCfg = new File(configDir, "jubitusbirds.cfg").toPath();
            Path oldLock = new File(configDir, "jubitusbirds.cfg.lock").toPath();
            Path oldBak = new File(configDir, "jubitusbirds.cfg.bak").toPath();
            boolean deletedAny = false;
            if (Files.exists(oldCfg, new LinkOption[0])) {
                Files.delete(oldCfg);
                deletedAny = true;
                LOGGER.info("[JubitusBirds] Deleted old config: {}", (Object)oldCfg.toAbsolutePath());
            }
            if (Files.exists(oldLock, new LinkOption[0])) {
                Files.delete(oldLock);
                deletedAny = true;
                LOGGER.info("[JubitusBirds] Deleted old config lock: {}", (Object)oldLock.toAbsolutePath());
            }
            if (Files.exists(oldBak, new LinkOption[0])) {
                Files.delete(oldBak);
                deletedAny = true;
                LOGGER.info("[JubitusBirds] Deleted old config backup: {}", (Object)oldBak.toAbsolutePath());
            }
            if (!deletedAny) {
                LOGGER.info("[JubitusBirds] No old root config to delete.");
            }
        }
        catch (Exception e) {
            LOGGER.warn("[JubitusBirds] Failed deleting old root config files.", (Throwable)e);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
    }
}

