/*
 * Decompiled with CFR 0.152.
 */
package com.jubitus.birds.client;

import com.jubitus.birds.client.ClientBird;
import com.jubitus.birds.client.config.BirdConfig;
import com.jubitus.birds.client.config.JubitusBirdsConfig;
import com.jubitus.birds.client.sound.BirdSoundSystem;
import com.jubitus.birds.client.util.Flock;
import com.jubitus.birds.client.util.FlockSpawner;
import com.jubitus.birds.client.util.SpatialHash;
import com.jubitus.birds.render.RenderBird;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class BirdManager {
    public static BirdManager INSTANCE;
    private final Map<Long, ClientBird> birdsById = new HashMap<Long, ClientBird>();
    private final Map<Long, Flock> flocksById = new HashMap<Long, Flock>();
    private final SpatialHash spatial = new SpatialHash(24);

    public BirdManager() {
        INSTANCE = this;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        EntityPlayerSP player = mc.field_71439_g;
        if (world == null || player == null) {
            return;
        }
        BirdSoundSystem.tickCleanup();
        int viewChunks = mc.field_71474_y.field_151451_c;
        double viewBorder = (double)viewChunks * 16.0;
        double despawnDist = viewBorder + BirdConfig.despawnBorderBuffer;
        double despawnDist2 = despawnDist * despawnDist;
        this.spatial.clear();
        for (ClientBird b : this.birdsById.values()) {
            this.spatial.insert(b);
        }
        for (Flock f : this.flocksById.values()) {
            f.tick((World)world);
        }
        Vec3d cam = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Iterator<Map.Entry<Long, ClientBird>> it = this.birdsById.entrySet().iterator();
        while (it.hasNext()) {
            Flock f;
            ClientBird b = it.next().getValue();
            Vec3d flockForward = null;
            if (b.flockId != 0L && (f = this.flocksById.get(b.flockId)) != null) {
                flockForward = f.getGroupForward();
            }
            List<ClientBird> neighbors = this.spatial.queryNearby(b.pos);
            b.tick((World)world, flockForward, neighbors);
            double d2 = b.pos.func_72436_e(cam);
            if (b.ageTicks <= 60 || !(d2 > despawnDist2)) continue;
            BirdSoundSystem.stopForBird(b.getId());
            it.remove();
        }
        this.cleanupFlocks();
        if (this.birdsById.size() >= BirdConfig.maxBirdsAroundPlayer) {
            return;
        }
        long t = world.func_72820_D() % 24000L;
        if (t > 13000L) {
            return;
        }
        long worldSeed = world.func_72905_C();
        int dim = world.field_73011_w.getDimension();
        long window = world.func_82737_E() / (long)BirdConfig.spawnTimeWindowTicks;
        int cell = BirdConfig.spawnCellSize;
        int px = (int)Math.floor(player.field_70165_t);
        int pz = (int)Math.floor(player.field_70161_v);
        int cellX = BirdManager.floorDiv(px, cell);
        int cellZ = BirdManager.floorDiv(pz, cell);
        int radiusCells = JubitusBirdsConfig.SPAWNING.spawnRadiusCells;
        FlockSpawner.SpawnResult sr = FlockSpawner.spawnForCells((World)world, (EntityPlayer)player, worldSeed, dim, window, cellX, cellZ, radiusCells);
        this.flocksById.putAll(sr.flocks);
        for (ClientBird b : sr.birds) {
            long id = b.getId();
            if (this.birdsById.containsKey(id)) continue;
            this.birdsById.put(id, b);
            if (this.birdsById.size() < BirdConfig.maxBirdsAroundPlayer) continue;
            break;
        }
        BirdSoundSystem.tickCleanup();
    }

    private void cleanupFlocks() {
        if (this.flocksById.isEmpty()) {
            return;
        }
        HashSet<Long> used = new HashSet<Long>();
        for (ClientBird b : this.birdsById.values()) {
            if (b.flockId == 0L) continue;
            used.add(b.flockId);
        }
        this.flocksById.keySet().removeIf(id -> !used.contains(id));
    }

    private static int floorDiv(int a, int b) {
        int r = a / b;
        if ((a ^ b) < 0 && r * b != a) {
            --r;
        }
        return r;
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent e) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null) {
            return;
        }
        RenderBird.renderAll(this.birdsById.values(), e.getPartialTicks());
    }

    public void clearAllBirds() {
        BirdSoundSystem.stopAll();
        this.birdsById.clear();
        this.flocksById.clear();
    }

    public Collection<ClientBird> getAllBirdsForDebug() {
        return this.birdsById.values();
    }
}

