/*
 * Decompiled with CFR 0.152.
 */
package com.jubitus.birds.client;

import com.jubitus.birds.client.config.BirdConfig;
import com.jubitus.birds.client.sound.BirdCallSound;
import com.jubitus.birds.client.sound.BirdCallType;
import com.jubitus.birds.client.sound.BirdSoundSystem;
import com.jubitus.birds.client.util.BirdOrientation;
import com.jubitus.birds.client.util.BirdSteering;
import com.jubitus.birds.client.util.FlockingRules;
import com.jubitus.birds.species.BirdSpecies;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ClientBird {
    private static final double MAX_CLIMB_PER_TICK = 0.2;
    private static final double COLLISION_BUFFER = 1.0;
    private static final FlockingRules.Params FLOCK_PARAMS = new FlockingRules.Params();
    public final BirdSpecies species;
    public final BirdOrientation orientation = new BirdOrientation();
    public final ResourceLocation texture;
    private final long birdSeed;
    private final Random rng;
    public int ageTicks = 0;
    public Vec3d pos;
    public Vec3d vel;
    public long flockId = 0L;
    public Vec3d prevPos;
    public float prevYaw;
    public float prevPitch;
    public float prevRoll;
    private long nextCallWorldTick = -1L;
    private double smoothVy = 0.0;
    private Vec3d forward;
    private Vec3d waypoint;
    private Vec3d circleCenter;
    private double circleRadius;
    private int modeTicksLeft;
    private Mode mode;
    private Vec3d lastForwardXZ = new Vec3d(0.0, 0.0, 1.0);

    public ClientBird(World world, BirdSpecies species, long birdSeed, Vec3d startPos, Vec3d initialDir, double speed) {
        this.species = species;
        this.birdSeed = birdSeed;
        this.rng = new Random(birdSeed);
        this.pos = startPos;
        this.forward = initialDir.func_72432_b();
        this.vel = this.forward.func_186678_a(speed);
        this.texture = species != null ? species.pickTexture(birdSeed) : null;
        this.pickNewMode(world, true);
        BirdSpecies.BirdSpeciesView v = species.viewForTime(world.func_72935_r());
        BirdSpecies.SoundView sv = v.sound(BirdCallType.SINGLE);
        this.scheduleNextCall(world, world.func_82737_E(), sv, true);
    }

    private void pickNewMode(World world, boolean first) {
        BirdSpecies.BirdSpeciesView v;
        double gy;
        double minY;
        BirdSpecies.BirdSpeciesView v2;
        boolean chooseCircle;
        double wG = this.species.patternWeightGlide;
        double wC = this.species.patternWeightCircle;
        double sum = wG + wC;
        double r = this.rng.nextDouble() * sum;
        boolean bl = chooseCircle = r >= wG;
        if (chooseCircle) {
            this.mode = Mode.CIRCLE;
            v2 = this.species.viewForTime(world.func_72935_r());
            this.modeTicksLeft = this.randInt(v2.circleMinTicks(), v2.circleMaxTicks());
            this.circleRadius = ClientBird.lerp(v2.circleRadiusMin(), v2.circleRadiusMax(), this.rng.nextDouble());
            double ang = this.rng.nextDouble() * Math.PI * 2.0;
            double dx = Math.cos(ang) * this.circleRadius;
            double dz = Math.sin(ang) * this.circleRadius;
            this.circleCenter = new Vec3d(this.pos.field_72450_a + dx, this.pos.field_72448_b, this.pos.field_72449_c + dz);
        } else {
            this.mode = Mode.GLIDE;
            v2 = this.species.viewForTime(world.func_72935_r());
            this.modeTicksLeft = this.randInt(v2.glideMinTicks(), v2.glideMaxTicks());
            this.pickGlideWaypoint(world);
        }
        if (first && this.pos.field_72448_b < (minY = (gy = ClientBird.getGroundY(world, this.pos.field_72450_a, this.pos.field_72449_c)) + (v = this.species.viewForTime(world.func_72935_r())).minAltitudeAboveGround())) {
            this.pos = new Vec3d(this.pos.field_72450_a, minY, this.pos.field_72449_c);
        }
    }

    private void scheduleNextCall(World world, long now, BirdSpecies.SoundView sv, boolean firstSchedule) {
        int base = sv.soundBaseIntervalTicks();
        double r = sv.soundRandomness();
        double factor = 1.0;
        if (r > 0.0) {
            factor = 1.0 - r + this.rng.nextDouble() * (2.0 * r);
        }
        long delay = Math.max(20L, Math.round((double)base * factor));
        long extraPhase = 0L;
        if (firstSchedule) {
            long cap = Math.min(600L, (long)base);
            extraPhase = cap > 0L ? (long)(this.rng.nextDouble() * (double)cap) : 0L;
        }
        long seedOffset = this.birdSeed & 0xFFL;
        this.nextCallWorldTick = now + delay + seedOffset + extraPhase;
    }

    private int randInt(int a, int b) {
        return a + this.rng.nextInt(b - a + 1);
    }

    private static double lerp(double a, double b, double t) {
        return a + (b - a) * t;
    }

    private void pickGlideWaypoint(World world) {
        double dist = 80.0 + this.rng.nextDouble() * 140.0;
        double ang = Math.atan2(this.forward.field_72449_c, this.forward.field_72450_a) + (this.rng.nextDouble() - 0.5) * Math.toRadians(50.0);
        double wx = this.pos.field_72450_a + Math.cos(ang) * dist;
        double wz = this.pos.field_72449_c + Math.sin(ang) * dist;
        double gy = ClientBird.getGroundY(world, wx, wz);
        BirdSpecies.BirdSpeciesView v = this.species.viewForTime(world.func_72935_r());
        double targetAbove = ClientBird.lerp(v.preferredAboveGround() - 15.0, v.preferredAboveGround() + 15.0, this.rng.nextDouble());
        double wy = gy + ClientBird.clamp(targetAbove, v.minAltitudeAboveGround(), v.maxAltitudeAboveGround());
        this.waypoint = new Vec3d(wx, wy, wz);
    }

    private static double getGroundY(World world, double x, double z) {
        BlockPos pos = new BlockPos(x, 0.0, z);
        BlockPos top = world.func_175645_m(pos);
        return top.func_177956_o();
    }

    private static double clamp(double v, double lo, double hi) {
        return Math.max(lo, Math.min(hi, v));
    }

    private static Vec3d turnToward(Vec3d current, Vec3d desired, double maxDegPerTick) {
        Vec3d d;
        Vec3d c = new Vec3d(current.field_72450_a, 0.0, current.field_72449_c).func_72432_b();
        double dot = ClientBird.clamp(c.func_72430_b(d = new Vec3d(desired.field_72450_a, 0.0, desired.field_72449_c).func_72432_b()), -1.0, 1.0);
        double angle = Math.acos(dot);
        if (angle < 1.0E-6) {
            return desired.func_72432_b();
        }
        double max = Math.toRadians(maxDegPerTick);
        double t = Math.min(1.0, max / angle);
        Vec3d blended = c.func_186678_a(1.0 - t).func_178787_e(d.func_186678_a(t)).func_72432_b();
        return new Vec3d(blended.field_72450_a, desired.field_72448_b * 0.2, blended.field_72449_c).func_72432_b();
    }

    private static float distanceToPlayer(World world, Vec3d soundPos) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71439_g == null) {
            return Float.MAX_VALUE;
        }
        double px = mc.field_71439_g.field_70165_t;
        double py = mc.field_71439_g.field_70163_u + (double)mc.field_71439_g.func_70047_e();
        double pz = mc.field_71439_g.field_70161_v;
        double dx = px - soundPos.field_72450_a;
        double dy = py - soundPos.field_72448_b;
        double dz = pz - soundPos.field_72449_c;
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public void tick(World world, Vec3d flockForward, List<ClientBird> neighbors) {
        Vec3d boidsForce;
        if (world == null) {
            return;
        }
        this.prevPos = this.pos;
        this.prevYaw = this.orientation.yawDeg;
        this.prevPitch = this.orientation.pitchDeg;
        this.prevRoll = this.orientation.rollDeg;
        ++this.ageTicks;
        boolean isDay = world.func_72935_r();
        BirdSpecies.BirdSpeciesView v = this.species.viewForTime(isDay);
        if (this.modeTicksLeft-- <= 0) {
            this.pickNewMode(world, false);
        }
        Vec3d desiredDir = this.flockId != 0L && flockForward != null && flockForward.func_189985_c() > 1.0E-8 ? new Vec3d(flockForward.field_72450_a, 0.0, flockForward.field_72449_c).func_72432_b() : this.computeDesiredDirection(world);
        if (this.flockId != 0L && flockForward != null) {
            desiredDir = desiredDir.func_178787_e(flockForward.func_186678_a(0.35)).func_72432_b();
        }
        if (this.flockId != 0L && neighbors != null && (boidsForce = FlockingRules.boidsSteer(this, neighbors, FLOCK_PARAMS)).func_189985_c() > 1.0E-8) {
            desiredDir = desiredDir.func_178787_e(boidsForce).func_72432_b();
        }
        double noise = v.noiseStrength();
        if (this.flockId != 0L) {
            noise *= 0.2;
        }
        desiredDir = desiredDir.func_72441_c((this.rng.nextDouble() - 0.5) * noise, (this.rng.nextDouble() - 0.5) * (noise * 0.3), (this.rng.nextDouble() - 0.5) * noise).func_72432_b();
        double maxTurnRad = Math.toRadians(v.maxTurnDegPerTick());
        this.forward = BirdSteering.limitTurnXZ(this.forward, desiredDir, maxTurnRad);
        double targetY = this.computeTargetY(world);
        double requiredMinY = this.computeRequiredMinY(world);
        double safetyBuffer = 4.0;
        double safeTargetY = targetY;
        if (this.pos.field_72448_b < requiredMinY + 10.0) {
            safeTargetY = Math.max(targetY, requiredMinY + safetyBuffer);
        }
        double yError = safeTargetY - this.pos.field_72448_b;
        double maxUp = this.pos.field_72448_b < requiredMinY ? 0.09 : 0.06;
        double maxDown = 0.06;
        double desiredVy = ClientBird.clamp(yError * v.verticalAdjustStrength(), -maxDown, maxUp);
        Vec3d avoid = this.obstacleAvoidance(world);
        if (avoid != null) {
            double maxTurnRadAvoid = Math.toRadians(v.maxTurnDegPerTick() * 1.25);
            this.forward = BirdSteering.limitTurnXZ(this.forward, avoid, maxTurnRadAvoid);
            if (this.pos.field_72448_b < requiredMinY + 6.0) {
                desiredVy = Math.max(desiredVy, 0.015);
            }
        }
        this.smoothVy = ClientBird.lerp(this.smoothVy, desiredVy, 0.06);
        double vy = ClientBird.clamp(this.smoothVy, -maxDown, maxUp);
        double speed = this.vel.func_72433_c();
        double targetSpeed = this.mode == Mode.CIRCLE ? ClientBird.lerp(v.minSpeed(), v.maxSpeed(), 0.35) : ClientBird.lerp(v.minSpeed(), v.maxSpeed(), 0.65);
        speed = ClientBird.lerp(speed, targetSpeed, 0.03);
        Vec3d horiz = new Vec3d(this.forward.field_72450_a, 0.0, this.forward.field_72449_c);
        if (horiz.func_189985_c() < 1.0E-6) {
            horiz = new Vec3d(1.0, 0.0, 0.0);
        }
        horiz = horiz.func_72432_b().func_186678_a(speed);
        this.vel = new Vec3d(horiz.field_72450_a, vy, horiz.field_72449_c);
        Vec3d fNow = new Vec3d(this.forward.field_72450_a, 0.0, this.forward.field_72449_c);
        if (fNow.func_189985_c() > 1.0E-6) {
            fNow = fNow.func_72432_b();
        }
        Vec3d fPrev = this.lastForwardXZ;
        double cross = fPrev.field_72450_a * fNow.field_72449_c - fPrev.field_72449_c * fNow.field_72450_a;
        float targetRoll = (float)BirdSteering.clamp(-cross * 55.0, -35.0, 35.0);
        this.orientation.setTargetRoll(targetRoll, 3.0f);
        this.orientation.updateFromVelocity(this.vel, 6.0f, 4.0f, 3.0f);
        this.lastForwardXZ = fNow;
        Vec3d nextPos = this.pos.func_178787_e(this.vel);
        double requiredMinNext = this.computeRequiredMinYAt(world, nextPos) + 1.0;
        if (nextPos.field_72448_b < requiredMinNext) {
            double needed = requiredMinNext - nextPos.field_72448_b;
            double lift = Math.min(needed, 0.2);
            nextPos = new Vec3d(nextPos.field_72450_a, nextPos.field_72448_b + lift, nextPos.field_72449_c);
            this.smoothVy = Math.max(this.smoothVy, lift);
        }
        this.tryPlayCall(world, world.func_82737_E(), v);
        this.pos = nextPos;
    }

    private Vec3d computeDesiredDirection(World world) {
        if (this.mode == Mode.GLIDE) {
            Vec3d to = this.waypoint.func_178788_d(this.pos);
            if (to.func_189985_c() < 16.0) {
                this.pickGlideWaypoint(world);
                to = this.waypoint.func_178788_d(this.pos);
            }
            return to.func_72432_b();
        }
        Vec3d toCenter = this.circleCenter.func_178788_d(this.pos);
        Vec3d radial = new Vec3d(toCenter.field_72450_a, 0.0, toCenter.field_72449_c);
        if (radial.func_189985_c() < 1.0E-6) {
            radial = new Vec3d(1.0, 0.0, 0.0);
        }
        radial = radial.func_72432_b();
        boolean cw = (this.birdSeed & 1L) == 0L;
        Vec3d tangent = cw ? new Vec3d(-radial.field_72449_c, 0.0, radial.field_72450_a) : new Vec3d(radial.field_72449_c, 0.0, -radial.field_72450_a);
        double dist = new Vec3d(this.pos.field_72450_a - this.circleCenter.field_72450_a, 0.0, this.pos.field_72449_c - this.circleCenter.field_72449_c).func_72433_c();
        double err = this.circleRadius - dist;
        Vec3d correction = radial.func_186678_a(-err * 0.02);
        return tangent.func_178787_e(correction).func_72432_b();
    }

    private double computeTargetY(World world) {
        double ground = ClientBird.getGroundY(world, this.pos.field_72450_a, this.pos.field_72449_c);
        BirdSpecies.BirdSpeciesView v = this.species.viewForTime(world.func_72935_r());
        double band = ClientBird.lerp(v.preferredAboveGround() - 20.0, v.preferredAboveGround() + 20.0, this.pseudoNoise01(world));
        double desiredAbove = ClientBird.clamp(band, v.minAltitudeAboveGround(), v.maxAltitudeAboveGround());
        return ground + desiredAbove;
    }

    private double pseudoNoise01(World world) {
        long t = world.func_82737_E() / 40L;
        long x = this.birdSeed ^ t * -7046029254386353131L;
        x ^= x >>> 33;
        x *= -49064778989728563L;
        x ^= x >>> 33;
        return (double)(x & 0xFFFFL) / 65535.0;
    }

    private Vec3d obstacleAvoidance(World world) {
        Vec3d start = this.pos;
        Vec3d end = this.pos.func_178787_e(this.forward.func_186678_a(16.0));
        RayTraceResult hit = world.func_147447_a(start, end, false, true, false);
        if (hit != null && hit.field_72313_a == RayTraceResult.Type.BLOCK) {
            boolean left = (this.birdSeed & 2L) == 0L;
            Vec3d side = left ? new Vec3d(-this.forward.field_72449_c, 0.0, this.forward.field_72450_a) : new Vec3d(this.forward.field_72449_c, 0.0, -this.forward.field_72450_a);
            return this.forward.func_178787_e(side.func_186678_a(0.8)).func_72432_b();
        }
        return null;
    }

    public long getId() {
        return this.birdSeed;
    }

    private double getGroundAheadY(World world, double lookAheadDist) {
        Vec3d f = new Vec3d(this.forward.field_72450_a, 0.0, this.forward.field_72449_c);
        if (f.func_189985_c() < 1.0E-6) {
            f = new Vec3d(0.0, 0.0, 1.0);
        }
        f = f.func_72432_b();
        double ax = this.pos.field_72450_a + f.field_72450_a * lookAheadDist;
        double az = this.pos.field_72449_c + f.field_72449_c * lookAheadDist;
        return ClientBird.getGroundY(world, ax, az);
    }

    private double computeRequiredMinY(World world) {
        double[] ds = new double[]{0.0, 6.0, 12.0, 18.0, 26.0, 34.0};
        double gMax = -1.0E9;
        for (double d : ds) {
            double g = this.getGroundAheadY(world, d);
            if (!(g > gMax)) continue;
            gMax = g;
        }
        BirdSpecies.BirdSpeciesView v = this.species.viewForTime(world.func_72935_r());
        return gMax + v.minAltitudeAboveGround();
    }

    private double computeRequiredMinYAt(World world, Vec3d atPos) {
        Vec3d f = new Vec3d(this.forward.field_72450_a, 0.0, this.forward.field_72449_c);
        if (f.func_189985_c() < 1.0E-6) {
            f = new Vec3d(0.0, 0.0, 1.0);
        }
        f = f.func_72432_b();
        double[] ds = new double[]{0.0, 6.0, 12.0, 18.0, 26.0};
        double gMax = -1.0E9;
        for (double d : ds) {
            double ax = atPos.field_72450_a + f.field_72450_a * d;
            double az = atPos.field_72449_c + f.field_72449_c * d;
            double g = ClientBird.getGroundY(world, ax, az);
            if (!(g > gMax)) continue;
            gMax = g;
        }
        BirdSpecies.BirdSpeciesView v = this.species.viewForTime(world.func_72935_r());
        return gMax + v.minAltitudeAboveGround();
    }

    private void tryPlayCall(World world, long now, BirdSpecies.BirdSpeciesView v) {
        BirdCallType type;
        if (world == null || v == null) {
            return;
        }
        if (this.species == null) {
            return;
        }
        if (!v.soundsEnabled()) {
            return;
        }
        if (this.species.soundKey == null || this.species.soundKey.isEmpty()) {
            return;
        }
        BirdCallType birdCallType = type = this.flockId != 0L ? BirdCallType.FLOCK : BirdCallType.SINGLE;
        if (!BirdSoundSystem.hasSounds(this.species.soundKey, type)) {
            return;
        }
        BirdSpecies.SoundView sv = v.sound(type);
        if (this.nextCallWorldTick < 0L) {
            this.scheduleNextCall(world, now, sv, true);
            return;
        }
        if (now < this.nextCallWorldTick) {
            return;
        }
        float vol = (float)(sv.soundVolume() * BirdConfig.masterBirdVolume);
        if (vol > (float)BirdConfig.masterBirdVolumeClamp) {
            vol = (float)BirdConfig.masterBirdVolumeClamp;
        }
        if (vol < 0.0f) {
            vol = 0.0f;
        }
        float pit = (float)sv.soundPitch();
        double var = sv.soundPitchVariation();
        if (var > 0.0) {
            double jitter = (this.rng.nextDouble() * 2.0 - 1.0) * var;
            pit = (float)((double)pit * (1.0 + jitter));
        }
        pit = (float)Math.max(0.5, Math.min(2.0, (double)pit));
        float maxDist = (float)sv.soundMaxDistance();
        float distNow = ClientBird.distanceToPlayer(world, this.pos);
        float fadeStart = (float)sv.soundFadeStart();
        float fadePower = (float)sv.soundFadePower();
        if (distNow >= maxDist) {
            this.scheduleNextCall(world, now, sv, false);
            return;
        }
        ResourceLocation rl = BirdSoundSystem.getCallEvent(this.species.soundKey, type);
        SoundEvent evt = BirdSoundSystem.getOrCreateEvent(rl);
        BirdCallSound sound = new BirdCallSound(this, world, evt, vol, pit, maxDist, fadeStart, fadePower);
        BirdSoundSystem.playCallIfAllowed(this.getId(), this.flockId, type, sound);
        this.scheduleNextCall(world, now, sv, false);
    }

    public static enum Mode {
        GLIDE,
        CIRCLE;

    }
}

