/*
 * Decompiled with CFR 0.152.
 */
package com.jubitus.birds.client.gui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.jubitus.birds.client.BirdManager;
import com.jubitus.birds.client.sound.BirdSoundSystem;
import com.jubitus.birds.species.BirdSpecies;
import com.jubitus.birds.species.BirdSpeciesLoader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class GuiSpeciesEditorScreen
extends GuiScreen {
    private static final Map<String, String[]> ENTRY_TOOLTIPS = new HashMap<String, String[]>();
    private static final int PAD = 10;
    private static final int TITLE_H = 24;
    private static final int BTN_H = 24;
    private static final int LIST_ROW_H = 22;
    private static final int PANEL_W_MIN = 170;
    private static final int PANEL_W_MAX = 260;
    private static final int PREVIEW_H = 200;
    private static final int PREVIEW_TEX_SIZE = 120;
    private final GuiScreen parent;
    private final BirdSpecies species;
    private final List<JsonEntry> entries = new ArrayList<JsonEntry>();
    private int lastW = -1;
    private int lastH = -1;
    private JsonObject rootJson;
    private EntrySlotList entryList;
    private GuiButton btnSave;
    private GuiButton btnCancel;
    private GuiButton btnReloadFromDisk;
    private int previewX;
    private int previewY;
    private int previewW;
    private int previewH;

    public GuiSpeciesEditorScreen(GuiScreen parent, BirdSpecies species) {
        this.parent = parent;
        this.species = species;
    }

    private static void putTip(String key, String ... lines) {
        ENTRY_TOOLTIPS.put(key, lines);
    }

    private static void initTooltipsOnce() {
        if (!ENTRY_TOOLTIPS.isEmpty()) {
            return;
        }
        GuiSpeciesEditorScreen.putTip("name", "Display name of the default_species.", "Shown in the default_species list and editor title.");
        GuiSpeciesEditorScreen.putTip("enabled", "If false, this default_species will NOT spawn.");
        GuiSpeciesEditorScreen.putTip("spawnWeight", "Relative chance of being picked when multiple default_species are allowed.", "Higher = more common, lower = rarer.");
        GuiSpeciesEditorScreen.putTip("birdsPerCellMax", "Max number of single birds this default_species can spawn per cell.", "Higher = more birds overall.");
        GuiSpeciesEditorScreen.putTip("flockChancePerCell", "Chance that a spawn cell produces a flock instead of singles.", "0.0 = never, 1.0 = always.");
        GuiSpeciesEditorScreen.putTip("flockMin", "Minimum size of a normal flock.");
        GuiSpeciesEditorScreen.putTip("flockMax", "Maximum size of a normal flock.");
        GuiSpeciesEditorScreen.putTip("bigFlockChanceDay", "Chance (day) that a spawned flock becomes a BIG flock.");
        GuiSpeciesEditorScreen.putTip("bigFlockChanceNight", "Chance (night) that a spawned flock becomes a BIG flock.");
        GuiSpeciesEditorScreen.putTip("bigFlockMin", "Minimum size of a big flock.");
        GuiSpeciesEditorScreen.putTip("bigFlockMax", "Maximum size of a big flock.");
        GuiSpeciesEditorScreen.putTip("biomeWhitelist", "Only allow spawning in these biomes (if not empty).", "You can use registry ids (minecraft:plains) or biome names.", "Tip: leave empty to allow everywhere (except blacklist).");
        GuiSpeciesEditorScreen.putTip("biomeBlacklist", "Never allow spawning in these biomes.", "Blacklist wins over whitelist.");
        GuiSpeciesEditorScreen.putTip("canSpawnAtDay", "If false, this default_species will not spawn during the day.");
        GuiSpeciesEditorScreen.putTip("canSpawnAtNight", "If true, this default_species can spawn during the night.");
        GuiSpeciesEditorScreen.putTip("minSpeed", "Minimum flight speed (blocks/tick).");
        GuiSpeciesEditorScreen.putTip("maxSpeed", "Maximum flight speed (blocks/tick).");
        GuiSpeciesEditorScreen.putTip("maxTurnDegPerTick", "How fast the bird can turn per tick (degrees).", "Higher = more agile, lower = smoother/wider turns.");
        GuiSpeciesEditorScreen.putTip("noiseStrength", "How much random wandering is added to flight direction.", "Higher = more chaotic flight.");
        GuiSpeciesEditorScreen.putTip("minAltitudeAboveGround", "Minimum height above ground (blocks).");
        GuiSpeciesEditorScreen.putTip("maxAltitudeAboveGround", "Maximum height above ground (blocks).");
        GuiSpeciesEditorScreen.putTip("preferredAboveGround", "Preferred cruising height above ground (blocks).");
        GuiSpeciesEditorScreen.putTip("verticalAdjustStrength", "How strongly the bird corrects toward its target altitude.", "Small values = gentle altitude changes.");
        GuiSpeciesEditorScreen.putTip("glideMinTicks", "Minimum duration of GLIDE mode (ticks).", "20 ticks = 1 second.");
        GuiSpeciesEditorScreen.putTip("glideMaxTicks", "Maximum duration of GLIDE mode (ticks).");
        GuiSpeciesEditorScreen.putTip("circleMinTicks", "Minimum duration of CIRCLE mode (ticks).");
        GuiSpeciesEditorScreen.putTip("circleMaxTicks", "Maximum duration of CIRCLE mode (ticks).");
        GuiSpeciesEditorScreen.putTip("circleRadiusMin", "Minimum circle radius (blocks) while circling.");
        GuiSpeciesEditorScreen.putTip("circleRadiusMax", "Maximum circle radius (blocks) while circling.");
        GuiSpeciesEditorScreen.putTip("patternWeightGlide", "How often the bird chooses GLIDE mode.", "Bigger = more gliding overall.");
        GuiSpeciesEditorScreen.putTip("patternWeightCircle", "How often the bird chooses CIRCLE mode.", "Bigger = more circling overall.");
        GuiSpeciesEditorScreen.putTip("scale", "Visual size of the bird model/quad.");
        GuiSpeciesEditorScreen.putTip("flapAmplitude", "How strong the wing wobble is.", "0 = no flap.");
        GuiSpeciesEditorScreen.putTip("flapSpeed", "How fast the wing wobble animates.");
    }

    private static JsonObject deepMerge(JsonObject base, JsonObject override) {
        if (base == null) {
            base = new JsonObject();
        }
        if (override == null) {
            return base;
        }
        for (Map.Entry e : override.entrySet()) {
            String k = (String)e.getKey();
            JsonElement v = (JsonElement)e.getValue();
            if (v != null && v.isJsonObject()) {
                JsonObject baseChild = base.has(k) && base.get(k).isJsonObject() ? base.getAsJsonObject(k) : new JsonObject();
                JsonObject mergedChild = GuiSpeciesEditorScreen.deepMerge(baseChild, v.getAsJsonObject());
                base.add(k, (JsonElement)mergedChild);
                continue;
            }
            base.add(k, v);
        }
        return base;
    }

    private static void setJsonValue(JsonObject root, String dottedPath, JsonElement value) {
        String[] parts = dottedPath.split("\\.");
        JsonObject cur = root;
        for (int i = 0; i < parts.length - 1; ++i) {
            String k = parts[i];
            JsonElement next = cur.get(k);
            if (next == null || !next.isJsonObject()) {
                JsonObject created = new JsonObject();
                cur.add(k, (JsonElement)created);
                cur = created;
                continue;
            }
            cur = next.getAsJsonObject();
        }
        cur.add(parts[parts.length - 1], value);
    }

    private List<String> tooltipForPath(String path) {
        if (path == null) {
            return null;
        }
        GuiSpeciesEditorScreen.initTooltipsOnce();
        String prefix = null;
        String key = path;
        if (path.startsWith("day.")) {
            prefix = "Day override:";
            key = path.substring("day.".length());
        } else if (path.startsWith("night.")) {
            prefix = "Night override:";
            key = path.substring("night.".length());
        }
        String[] base = ENTRY_TOOLTIPS.get(key);
        if (base == null) {
            return null;
        }
        ArrayList<String> lines = new ArrayList<String>();
        if (prefix != null) {
            lines.add(prefix + " only applies during that time.");
            lines.addAll(Arrays.asList(base));
        } else {
            lines.addAll(Arrays.asList(base));
        }
        return lines;
    }

    private void drawEntryTooltips(int mouseX, int mouseY) {
        if (this.entries == null || this.entries.isEmpty()) {
            return;
        }
        for (JsonEntry e : this.entries) {
            if (e == null || e.kind == JsonEntry.Kind.HEADER || !e.isMouseOver(mouseX, mouseY)) continue;
            List<String> tip = this.tooltipForPath(e.path);
            if (tip != null && !tip.isEmpty()) {
                this.func_146283_a(tip, mouseX, mouseY);
            }
            return;
        }
    }

    private Path propertiesPath() {
        return BirdSpeciesLoader.getRootConfigDir().resolve(this.species.folderName).resolve("properties.json");
    }

    private void loadJsonFromDisk() {
        Path p = this.propertiesPath();
        try {
            String raw = new String(Files.readAllBytes(p), StandardCharsets.UTF_8);
            JsonElement el = new JsonParser().parse(raw);
            this.rootJson = el != null && el.isJsonObject() ? el.getAsJsonObject() : new JsonObject();
        }
        catch (Exception e) {
            this.rootJson = new JsonObject();
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString("\u00a7c[JubitusBirds] Failed reading: " + p));
        }
    }

    private void buildEntriesFromJson() {
        JsonObject merged;
        this.entries.clear();
        JsonObject schema = this.buildDefaultSchemaJson();
        this.rootJson = merged = GuiSpeciesEditorScreen.deepMerge(schema, this.rootJson);
        this.flatten("", this.rootJson);
    }

    private void flatten(String path, JsonObject obj) {
        for (Map.Entry e : obj.entrySet()) {
            String p;
            String key = (String)e.getKey();
            JsonElement val = (JsonElement)e.getValue();
            String string = p = path.isEmpty() ? key : path + "." + key;
            if (val == null || val.isJsonNull()) {
                JsonEntry je = JsonEntry.forString(p, "");
                je.wasNull = true;
                this.entries.add(je);
                continue;
            }
            if (val.isJsonObject()) {
                this.entries.add(JsonEntry.header(p));
                this.flatten(p, val.getAsJsonObject());
                continue;
            }
            if (val.isJsonArray()) {
                this.entries.add(JsonEntry.forArray(p, val.getAsJsonArray()));
                continue;
            }
            if (!val.isJsonPrimitive()) continue;
            JsonPrimitive prim = val.getAsJsonPrimitive();
            if (prim.isBoolean()) {
                this.entries.add(JsonEntry.forBoolean(p, prim.getAsBoolean()));
                continue;
            }
            if (prim.isNumber()) {
                this.entries.add(JsonEntry.forNumber(p, prim.getAsNumber().toString()));
                continue;
            }
            this.entries.add(JsonEntry.forString(p, prim.getAsString()));
        }
    }

    private void applyEntriesToJson() {
        for (JsonEntry en : this.entries) {
            String p;
            if (en.kind == JsonEntry.Kind.HEADER || (p = en.path) == null || p.trim().isEmpty()) continue;
            GuiSpeciesEditorScreen.setJsonValue(this.rootJson, p, en.toJsonElement());
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        if (this.field_146294_l != this.lastW || this.field_146295_m != this.lastH) {
            this.lastW = this.field_146294_l;
            this.lastH = this.field_146295_m;
            this.func_73866_w_();
        }
        String title = "Edit Species: " + (this.species.name != null ? this.species.name : this.species.folderName);
        this.func_73731_b(this.field_146289_q, title, 10, 10, 0xFFFFFF);
        if (this.entryList != null) {
            this.entryList.func_148128_a(mouseX, mouseY, partialTicks);
        }
        this.drawPreviewBox(partialTicks);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        for (JsonEntry e : this.entries) {
            if (e == null) continue;
            e.drawTextField();
        }
        this.drawEntryTooltips(mouseX, mouseY);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        for (JsonEntry e : this.entries) {
            if (e == null || !e.keyTyped(typedChar, keyCode)) continue;
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (JsonEntry e : this.entries) {
            if (e == null) continue;
            e.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        block7: {
            if (button.field_146127_k == 2) {
                this.field_146297_k.func_147108_a(this.parent);
                return;
            }
            if (button.field_146127_k == 3) {
                BirdSpeciesLoader.loadAllSpecies();
                this.func_73866_w_();
                return;
            }
            if (button.field_146127_k == 1) {
                this.applyEntriesToJson();
                try {
                    Gson g = new GsonBuilder().setPrettyPrinting().create();
                    String out = g.toJson((JsonElement)this.rootJson);
                    Files.write(this.propertiesPath(), out.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                    BirdSpeciesLoader.loadAllSpecies();
                    BirdSoundSystem.reloadSoundsOnly();
                    if (BirdManager.INSTANCE != null) {
                        BirdManager.INSTANCE.clearAllBirds();
                    }
                    if (this.field_146297_k.field_71439_g != null) {
                        this.field_146297_k.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("\u00a7a[JubitusBirds] Saved + reloaded " + this.species.folderName));
                    }
                    this.field_146297_k.func_147108_a(this.parent);
                }
                catch (Exception ex) {
                    if (this.field_146297_k.field_71439_g == null) break block7;
                    this.field_146297_k.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("\u00a7c[JubitusBirds] Save failed: " + ex.getMessage()));
                }
            }
        }
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.entries.clear();
        int panelW = MathHelper.func_76125_a((int)(this.field_146294_l / 4), (int)170, (int)260);
        int top = 24;
        int bottom = this.field_146295_m - 24 - 4;
        int listLeft = 10;
        int listRight = this.field_146294_l - panelW - 10;
        int listW = Math.max(60, listRight - listLeft);
        this.previewX = this.field_146294_l - panelW + 10;
        this.previewY = 24;
        this.previewW = panelW - 20;
        this.previewH = 200;
        int panelX = this.field_146294_l - panelW;
        int btnY = this.field_146295_m - 24;
        int gap = 4;
        int wSave = 55;
        int wCancel = 60;
        int wReload = 55;
        int totalW = wSave + gap + wCancel + gap + wReload;
        int x0 = Math.max(10, this.field_146294_l - 10 - totalW);
        this.btnSave = new GuiButton(1, x0, btnY, wSave, 20, "Save");
        this.btnCancel = new GuiButton(2, x0 + wSave + gap, btnY, wCancel, 20, "Cancel");
        this.btnReloadFromDisk = new GuiButton(3, x0 + wSave + gap + wCancel + gap, btnY, wReload, 20, "Reload");
        this.field_146292_n.add(this.btnSave);
        this.field_146292_n.add(this.btnCancel);
        this.field_146292_n.add(this.btnReloadFromDisk);
        this.loadJsonFromDisk();
        this.buildEntriesFromJson();
        this.entryList = new EntrySlotList(this.field_146297_k, this.field_146294_l, this.field_146295_m, top, bottom, 22, listLeft, listW, this.entries);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (this.entryList != null) {
            this.entryList.func_178039_p();
        }
    }

    private void drawPreviewBox(float partialTicks) {
        GuiSpeciesEditorScreen.func_73734_a((int)this.previewX, (int)this.previewY, (int)(this.previewX + this.previewW), (int)(this.previewY + this.previewH), (int)0x66000000);
        GuiSpeciesEditorScreen.func_73734_a((int)this.previewX, (int)this.previewY, (int)(this.previewX + this.previewW), (int)(this.previewY + 1), (int)-1711276033);
        String nm = this.species.name != null && !this.species.name.trim().isEmpty() ? this.species.name : this.species.folderName;
        this.func_73732_a(this.field_146289_q, nm, this.previewX + this.previewW / 2, this.previewY + 6, 0xFFFFFF);
        ResourceLocation tex = this.pickPreviewTexture();
        if (tex == null) {
            this.func_73732_a(this.field_146289_q, "(no textures)", this.previewX + this.previewW / 2, this.previewY + this.previewH / 2, 0xFFAAAA);
            return;
        }
        long ms = Minecraft.func_71386_F();
        float yaw = (float)(ms % 6000L) * 0.06f;
        int size = this.getPreviewSizePx();
        int cx = this.previewX + this.previewW / 2;
        int cy = this.previewY + this.previewH / 2 + 10;
        int pad = 4;
        int x0 = cx - size / 2 - pad;
        int y0 = cy - size / 2 - pad;
        int x1 = cx + size / 2 + pad;
        int y1 = cy + size / 2 + pad;
        this.drawPreviewFrame(x0, y0, x1, y1, this.getDaySkyARGB(), -16777216);
        this.drawTurntable3D(tex, cx, cy, size, yaw);
    }

    private ResourceLocation pickPreviewTexture() {
        if (this.species.textures == null || this.species.textures.isEmpty()) {
            return null;
        }
        if (this.species.textures.size() == 1) {
            return this.species.textures.get(0);
        }
        long ms = Minecraft.func_71386_F();
        int idx = (int)(ms / 3000L % (long)this.species.textures.size());
        return this.species.textures.get(idx);
    }

    private void drawRotatingTexture(ResourceLocation tex, int centerX, int centerY, int size, float angleDeg) {
        this.field_146297_k.func_110434_K().func_110577_a(tex);
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)centerX, (float)centerY, (float)0.0f);
        GlStateManager.func_179114_b((float)angleDeg, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)(-((float)size / 2.0f)), (float)(-((float)size / 2.0f)), (float)0.0f);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b(0.0, (double)size, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buf.func_181662_b((double)size, (double)size, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buf.func_181662_b((double)size, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        buf.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tess.func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private void drawMarioKartSpin(ResourceLocation tex, int centerX, int centerY, int size, float yawDeg) {
        this.field_146297_k.func_110434_K().func_110577_a(tex);
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)centerX, (float)centerY, (float)0.0f);
        GlStateManager.func_179114_b((float)yawDeg, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)(-((float)size / 2.0f)), (float)(-((float)size / 2.0f)), (float)0.0f);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b(0.0, (double)size, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buf.func_181662_b((double)size, (double)size, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buf.func_181662_b((double)size, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        buf.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tess.func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private JsonObject buildDefaultSchemaJson() {
        JsonObject root = new JsonObject();
        root.addProperty("name", this.species.folderName);
        root.addProperty("enabled", Boolean.valueOf(true));
        root.addProperty("spawnWeight", (Number)1.0);
        root.addProperty("birdsPerCellMax", (Number)8);
        root.addProperty("flockChancePerCell", (Number)0.45);
        root.addProperty("flockMin", (Number)3);
        root.addProperty("flockMax", (Number)10);
        root.addProperty("bigFlockChanceDay", (Number)0.35);
        root.addProperty("bigFlockChanceNight", (Number)0.1);
        root.addProperty("bigFlockMin", (Number)15);
        root.addProperty("bigFlockMax", (Number)40);
        root.add("biomeWhitelist", (JsonElement)new JsonArray());
        root.add("biomeBlacklist", (JsonElement)new JsonArray());
        root.addProperty("canSpawnAtDay", Boolean.valueOf(true));
        root.addProperty("canSpawnAtNight", Boolean.valueOf(false));
        root.addProperty("minSpeed", (Number)0.35);
        root.addProperty("maxSpeed", (Number)0.6);
        root.addProperty("maxTurnDegPerTick", (Number)4.0);
        root.addProperty("noiseStrength", (Number)0.04);
        root.addProperty("minAltitudeAboveGround", (Number)24.0);
        root.addProperty("maxAltitudeAboveGround", (Number)96.0);
        root.addProperty("preferredAboveGround", (Number)48.0);
        root.addProperty("verticalAdjustStrength", (Number)0.004);
        root.addProperty("glideMinTicks", (Number)60);
        root.addProperty("glideMaxTicks", (Number)140);
        root.addProperty("circleMinTicks", (Number)80);
        root.addProperty("circleMaxTicks", (Number)220);
        root.addProperty("circleRadiusMin", (Number)16.0);
        root.addProperty("circleRadiusMax", (Number)64.0);
        root.addProperty("patternWeightGlide", (Number)0.55);
        root.addProperty("patternWeightCircle", (Number)0.45);
        root.addProperty("scale", (Number)0.45);
        root.addProperty("flapAmplitude", (Number)0.08);
        root.addProperty("flapSpeed", (Number)0.35);
        JsonObject day = new JsonObject();
        day.addProperty("spawnWeight", (Number)1.0);
        day.addProperty("preferredAboveGround", (Number)48.0);
        JsonObject night = new JsonObject();
        night.addProperty("spawnWeight", (Number)1.0);
        night.addProperty("minSpeed", (Number)0.35);
        night.addProperty("maxSpeed", (Number)0.6);
        night.addProperty("preferredAboveGround", (Number)48.0);
        root.add("day", (JsonElement)day);
        root.add("night", (JsonElement)night);
        return root;
    }

    private int getPreviewSizePx() {
        ScaledResolution sr = new ScaledResolution(this.field_146297_k);
        int sf = sr.func_78325_e();
        int base = 120;
        float mult = 0.85f + 0.25f * (float)sf;
        int size = (int)((float)base * mult);
        int maxAllowed = Math.min(this.previewW - 16, this.previewH - 40);
        size = MathHelper.func_76125_a((int)size, (int)60, (int)Math.max(60, maxAllowed));
        return size;
    }

    private void drawTurntable3D(ResourceLocation tex, int centerX, int centerY, int size, float yawDeg) {
        this.field_146297_k.func_110434_K().func_110577_a(tex);
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179129_p();
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179109_b((float)centerX, (float)centerY, (float)200.0f);
        float s = (float)size / 2.0f;
        GlStateManager.func_179152_a((float)s, (float)s, (float)s);
        float pitch = 25.0f;
        GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)yawDeg, (float)0.0f, (float)1.0f, (float)0.0f);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b(-1.0, 0.0, 1.0).func_187315_a(0.0, 0.0).func_181675_d();
        buf.func_181662_b(1.0, 0.0, 1.0).func_187315_a(1.0, 0.0).func_181675_d();
        buf.func_181662_b(1.0, 0.0, -1.0).func_187315_a(1.0, 1.0).func_181675_d();
        buf.func_181662_b(-1.0, 0.0, -1.0).func_187315_a(0.0, 1.0).func_181675_d();
        tess.func_78381_a();
        GlStateManager.func_179097_i();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private int getDaySkyARGB() {
        return -8674049;
    }

    private void drawPreviewFrame(int x0, int y0, int x1, int y1, int fillARGB, int borderARGB) {
        Gui.func_73734_a((int)x0, (int)y0, (int)x1, (int)y1, (int)fillARGB);
        Gui.func_73734_a((int)x0, (int)y0, (int)x1, (int)(y0 + 1), (int)borderARGB);
        Gui.func_73734_a((int)x0, (int)(y1 - 1), (int)x1, (int)y1, (int)borderARGB);
        Gui.func_73734_a((int)x0, (int)y0, (int)(x0 + 1), (int)y1, (int)borderARGB);
        Gui.func_73734_a((int)(x1 - 1), (int)y0, (int)x1, (int)y1, (int)borderARGB);
    }

    static class JsonEntry {
        private static final int LABEL_W = 190;
        final Kind kind;
        final String path;
        boolean wasNull;
        GuiTextField tf;
        GuiButton toggleBtn;
        boolean boolVal;
        private int x;
        private int y;
        private int w;
        private int h;

        private JsonEntry(Kind kind, String path) {
            this.kind = kind;
            this.path = path;
        }

        static JsonEntry header(String path) {
            return new JsonEntry(Kind.HEADER, path);
        }

        static JsonEntry forBoolean(String path, boolean v) {
            JsonEntry e = new JsonEntry(Kind.BOOL, path);
            e.boolVal = v;
            return e;
        }

        static JsonEntry forNumber(String path, String numText) {
            JsonEntry e = new JsonEntry(Kind.NUMBER, path);
            e.tf = new GuiTextField(0, Minecraft.func_71410_x().field_71466_p, 0, 0, 120, 18);
            e.tf.func_146180_a(numText != null ? numText : "0");
            return e;
        }

        static JsonEntry forString(String path, String s) {
            JsonEntry e = new JsonEntry(Kind.STRING, path);
            e.tf = new GuiTextField(0, Minecraft.func_71410_x().field_71466_p, 0, 0, 220, 18);
            e.tf.func_146180_a(s != null ? s : "");
            return e;
        }

        static JsonEntry forArray(String path, JsonArray arr) {
            JsonEntry e = new JsonEntry(Kind.ARRAY, path);
            e.tf = new GuiTextField(0, Minecraft.func_71410_x().field_71466_p, 0, 0, 260, 18);
            ArrayList<String> parts = new ArrayList<String>();
            if (arr != null) {
                for (JsonElement el : arr) {
                    if (el == null || !el.isJsonPrimitive()) continue;
                    parts.add(el.getAsString());
                }
            }
            e.tf.func_146180_a(String.join((CharSequence)", ", parts));
            return e;
        }

        boolean isMouseOver(int mx, int my) {
            return mx >= this.x && mx <= this.x + this.w && my >= this.y && my <= this.y + this.h;
        }

        void layout(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            int labelW = MathHelper.func_76125_a((int)((int)((float)w * 0.45f)), (int)90, (int)220);
            if (this.tf != null) {
                this.tf.field_146209_f = x + labelW;
                this.tf.field_146210_g = y + 2;
                this.tf.field_146218_h = Math.max(60, w - labelW - 10);
            }
            if (this.kind == Kind.BOOL) {
                if (this.toggleBtn == null) {
                    this.toggleBtn = new GuiButton(0, 0, 0, 70, 18, "");
                }
                this.toggleBtn.field_146128_h = x + labelW;
                this.toggleBtn.field_146129_i = y + 1;
                this.toggleBtn.field_146126_j = this.boolVal ? "true" : "false";
            }
        }

        void draw(int mouseX, int mouseY, float partialTicks) {
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            if (this.kind == Kind.HEADER) {
                fr.func_78276_b("[" + this.path + "]", this.x, this.y + 5, 0x66CCFF);
                return;
            }
            String label = this.path;
            int maxLabelPx = this.tf != null ? this.tf.field_146209_f - this.x - 6 : 200;
            label = fr.func_78269_a(label, Math.max(40, maxLabelPx));
            fr.func_78276_b(label, this.x, this.y + 6, 0xFFFFFF);
            if (this.tf != null) {
                this.tf.func_146194_f();
            }
            if (this.toggleBtn != null) {
                this.toggleBtn.func_191745_a(Minecraft.func_71410_x(), mouseX, mouseY, partialTicks);
            }
        }

        void drawTextField() {
        }

        void mouseClicked(int mx, int my, int btn) throws IOException {
            if (this.tf != null) {
                this.tf.func_146192_a(mx, my, btn);
            }
            if (this.toggleBtn != null && this.toggleBtn.func_146116_c(Minecraft.func_71410_x(), mx, my)) {
                this.boolVal = !this.boolVal;
                this.toggleBtn.func_146113_a(Minecraft.func_71410_x().func_147118_V());
            }
        }

        boolean keyTyped(char c, int key) throws IOException {
            if (this.tf != null && this.tf.func_146206_l()) {
                this.tf.func_146201_a(c, key);
                return true;
            }
            return false;
        }

        JsonElement toJsonElement() {
            switch (this.kind) {
                case BOOL: {
                    return new JsonPrimitive(Boolean.valueOf(this.boolVal));
                }
                case NUMBER: {
                    String t;
                    String string = t = this.tf != null ? this.tf.func_146179_b().trim() : "0";
                    if (t.isEmpty()) {
                        t = "0";
                    }
                    try {
                        if (t.contains(".") || t.contains("e") || t.contains("E")) {
                            return new JsonPrimitive((Number)Double.parseDouble(t));
                        }
                        long v = Long.parseLong(t);
                        if (v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE) {
                            return new JsonPrimitive((Number)((int)v));
                        }
                        return new JsonPrimitive((Number)v);
                    }
                    catch (Exception ex) {
                        return new JsonPrimitive((Number)0);
                    }
                }
                case ARRAY: {
                    String t;
                    JsonArray arr = new JsonArray();
                    String string = t = this.tf != null ? this.tf.func_146179_b() : "";
                    if (t != null && !t.trim().isEmpty()) {
                        String[] parts;
                        for (String p : parts = t.split(",")) {
                            String s = p.trim();
                            if (s.isEmpty()) continue;
                            arr.add((JsonElement)new JsonPrimitive(s));
                        }
                    }
                    return arr;
                }
                case STRING: {
                    String t;
                    String string = t = this.tf != null ? this.tf.func_146179_b() : "";
                    if (this.wasNull && (t == null || t.trim().isEmpty())) {
                        return JsonNull.INSTANCE;
                    }
                    return new JsonPrimitive(t != null ? t : "");
                }
            }
            return JsonNull.INSTANCE;
        }

        static enum Kind {
            HEADER,
            BOOL,
            NUMBER,
            STRING,
            ARRAY;

        }
    }

    static class EntrySlotList
    extends GuiSlot {
        private final List<JsonEntry> entries;
        private final int listLeft;
        private final int listW;

        public EntrySlotList(Minecraft mc, int screenW, int screenH, int topIn, int bottomIn, int slotHeightIn, int listLeft, int listW, List<JsonEntry> entries) {
            super(mc, screenW, screenH, topIn, bottomIn, slotHeightIn);
            this.entries = entries;
            this.listLeft = listLeft;
            this.listW = listW;
            this.field_148152_e = listLeft;
            this.field_148151_d = listLeft + listW;
        }

        protected int func_148127_b() {
            return this.entries.size();
        }

        protected void func_148144_a(int index, boolean doubleClick, int mouseX, int mouseY) {
        }

        protected boolean func_148131_a(int index) {
            return false;
        }

        protected void func_148123_a() {
        }

        protected void func_192637_a(int idx, int right, int y, int heightIn, int mouseXIn, int mouseYIn, float partialTicks) {
            JsonEntry e = this.entries.get(idx);
            if (e == null) {
                return;
            }
            int x = this.field_148152_e + 6;
            e.layout(x, y, this.listW - 12, heightIn);
            e.draw(mouseXIn, mouseYIn, partialTicks);
        }

        public int func_148139_c() {
            return this.listW;
        }

        protected int func_148137_d() {
            return this.field_148151_d - 6;
        }
    }
}

