/*
 * Decompiled with CFR 0.152.
 */
package com.jubitus.birds.client.gui;

import com.jubitus.birds.client.gui.GuiSpeciesEditorScreen;
import com.jubitus.birds.client.gui.JubitusMainConfigGui;
import com.jubitus.birds.client.gui.SpeciesSlotList;
import com.jubitus.birds.species.BirdSpecies;
import com.jubitus.birds.species.BirdSpeciesRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class GuiSpeciesListScreen
extends GuiScreen {
    private final GuiScreen parent;
    private final List<BirdSpecies> species = new ArrayList<BirdSpecies>();
    private SpeciesSlotList list;
    private GuiButton btnMainOptions;

    public GuiSpeciesListScreen(GuiScreen parent) {
        this.parent = parent;
    }

    void openEditor(BirdSpecies s) {
        if (s == null) {
            return;
        }
        this.field_146297_k.func_147108_a((GuiScreen)new GuiSpeciesEditorScreen(this, s));
    }

    List<BirdSpecies> getSpecies() {
        return this.species;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        if (this.list != null) {
            this.list.func_148128_a(mouseX, mouseY, partialTicks);
        }
        this.func_73732_a(this.field_146289_q, "JubitusBirds - Species", this.field_146294_l / 2, 10, 0xFFFFFF);
        if (this.species.isEmpty()) {
            this.func_73732_a(this.field_146289_q, "No default_species loaded. (Check config/jubitusbirds/default_species)", this.field_146294_l / 2, this.field_146295_m / 2, 0xFFAAAA);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 0) {
            this.field_146297_k.func_147108_a(this.parent);
            return;
        }
        if (button.field_146127_k == 1) {
            this.field_146297_k.func_147108_a((GuiScreen)new JubitusMainConfigGui(this));
        }
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.species.clear();
        this.species.addAll(BirdSpeciesRegistry.all());
        this.species.sort(Comparator.comparing(s -> s.name != null ? s.name.toLowerCase() : ""));
        int top = 28;
        int bottom = this.field_146295_m - 28;
        this.list = new SpeciesSlotList(this, this.field_146297_k, this.field_146294_l, this.field_146295_m, top, bottom, 28);
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l - 110, this.field_146295_m - 24, 100, 20, "Done"));
        this.btnMainOptions = new GuiButton(1, 10, this.field_146295_m - 24, 140, 20, "Main options menu");
        this.field_146292_n.add(this.btnMainOptions);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (this.list != null) {
            this.list.func_178039_p();
        }
    }

    ResourceLocation pickPreviewTexture(BirdSpecies s) {
        if (s == null || s.textures == null || s.textures.isEmpty()) {
            return null;
        }
        if (s.textures.size() == 1) {
            return s.textures.get(0);
        }
        long ms = Minecraft.func_71386_F();
        int idx = (int)(ms / 3000L % (long)s.textures.size());
        return s.textures.get(idx);
    }

    void drawTinyTurntable3D(ResourceLocation tex, int centerX, int centerY, int size, float yawDeg) {
        if (tex == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(tex);
        GlStateManager.func_187421_b((int)3553, (int)10241, (int)9728);
        GlStateManager.func_187421_b((int)3553, (int)10240, (int)9728);
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        GlStateManager.func_179140_f();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179097_i();
        GlStateManager.func_179109_b((float)centerX, (float)centerY, (float)0.0f);
        float s = (float)size / 2.0f;
        GlStateManager.func_179152_a((float)s, (float)s, (float)s);
        GlStateManager.func_179114_b((float)25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)yawDeg, (float)0.0f, (float)1.0f, (float)0.0f);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b(-1.0, 0.0, 1.0).func_187315_a(0.0, 0.0).func_181675_d();
        buf.func_181662_b(1.0, 0.0, 1.0).func_187315_a(1.0, 0.0).func_181675_d();
        buf.func_181662_b(1.0, 0.0, -1.0).func_187315_a(1.0, 1.0).func_181675_d();
        buf.func_181662_b(-1.0, 0.0, -1.0).func_187315_a(0.0, 1.0).func_181675_d();
        tess.func_78381_a();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    int getDaySkyARGB() {
        return -8674049;
    }

    void drawPreviewFrame(int x0, int y0, int x1, int y1, int fillARGB) {
        Gui.func_73734_a((int)x0, (int)y0, (int)x1, (int)y1, (int)fillARGB);
        int black = -16777216;
        Gui.func_73734_a((int)x0, (int)y0, (int)x1, (int)(y0 + 1), (int)black);
        Gui.func_73734_a((int)x0, (int)(y1 - 1), (int)x1, (int)y1, (int)black);
        Gui.func_73734_a((int)x0, (int)y0, (int)(x0 + 1), (int)y1, (int)black);
        Gui.func_73734_a((int)(x1 - 1), (int)y0, (int)x1, (int)y1, (int)black);
    }
}

