/*
 * Decompiled with CFR 0.152.
 */
package com.jubitus.birds.client.gui;

import com.jubitus.birds.client.gui.GuiSpeciesListScreen;
import com.jubitus.birds.species.BirdSpecies;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.util.ResourceLocation;

public class SpeciesSlotList
extends GuiSlot {
    private static final int PREVIEW_GUTTER_W = 78;
    private static final int PREVIEW_SHIFT_L = 156;
    private static final int PREVIEW_PAD_R = 6;
    private static final int PREVIEW_PAD = 2;
    private final GuiSpeciesListScreen owner;

    public SpeciesSlotList(GuiSpeciesListScreen owner, Minecraft mc, int width, int height, int topIn, int bottomIn, int slotHeightIn) {
        super(mc, width, height, topIn, bottomIn, slotHeightIn);
        this.owner = owner;
    }

    protected int func_148127_b() {
        return this.owner.getSpecies().size();
    }

    protected void func_148144_a(int index, boolean doubleClick, int mouseX, int mouseY) {
        if (index < 0 || index >= this.owner.getSpecies().size()) {
            return;
        }
        int rowY = this.field_148153_b + 4 - (int)this.field_148169_q + index * this.field_148149_f;
        if (this.isMouseOverPreview(rowY, this.field_148149_f, mouseX, mouseY)) {
            this.owner.openEditor(this.owner.getSpecies().get(index));
            return;
        }
        this.owner.openEditor(this.owner.getSpecies().get(index));
    }

    protected boolean func_148131_a(int index) {
        return false;
    }

    protected void func_148123_a() {
    }

    protected void func_192637_a(int index, int x, int y, int heightIn, int mouseXIn, int mouseYIn, float partialTicks) {
        BirdSpecies s = this.owner.getSpecies().get(index);
        String name = s.name != null ? s.name : "(unnamed)";
        String folder = s.folderName != null ? s.folderName : "?";
        int textX = x + 6;
        int textRightLimit = this.field_148151_d - 78;
        int maxTextW = Math.max(30, textRightLimit - textX);
        String nameTrim = this.field_148161_k.field_71466_p.func_78269_a(name, maxTextW);
        String folderTrim = this.field_148161_k.field_71466_p.func_78269_a("folder: " + folder, maxTextW);
        this.owner.func_73731_b(this.field_148161_k.field_71466_p, nameTrim, textX, y + 2, 0xFFFFFF);
        this.owner.func_73731_b(this.field_148161_k.field_71466_p, folderTrim, textX, y + 12, 0xAAAAAA);
        ResourceLocation tex = this.owner.pickPreviewTexture(s);
        if (tex != null) {
            int size = heightIn - 4;
            int cy = y + heightIn / 2;
            int cx = this.field_148151_d - 6 - size / 2 - 156;
            int pad = 2;
            int x0 = cx - size / 2 - pad;
            int y0 = cy - size / 2 - pad;
            int x1 = cx + size / 2 + pad;
            int y1 = cy + size / 2 + pad;
            int sky = this.owner.getDaySkyARGB();
            boolean hover = this.isMouseOverPreview(y, heightIn, mouseXIn, mouseYIn);
            int border = hover ? -1 : -16777216;
            this.owner.drawPreviewFrame(x0, y0, x1, y1, sky);
            long ms = Minecraft.func_71386_F();
            float yaw = (float)(ms % 6000L) * 0.06f;
            this.owner.drawTinyTurntable3D(tex, cx, cy, size, yaw);
            this.owner.drawTinyTurntable3D(tex, cx, cy, size, yaw);
        }
    }

    private boolean isMouseOverPreview(int rowY, int heightIn, int mouseX, int mouseY) {
        int size = heightIn - 4;
        int cy = rowY + heightIn / 2;
        int cx = this.field_148151_d - 6 - size / 2 - 156;
        int x0 = cx - size / 2 - 2;
        int y0 = cy - size / 2 - 2;
        int x1 = cx + size / 2 + 2;
        int y1 = cy + size / 2 + 2;
        return mouseX >= x0 && mouseX <= x1 && mouseY >= y0 && mouseY <= y1;
    }
}

