/*
 * Decompiled with CFR 0.152.
 */
package com.jubitus.birds.client.sound;

import com.jubitus.birds.client.ClientBird;
import com.jubitus.birds.client.config.BirdConfig;
import com.jubitus.birds.client.sound.BirdSoundSystem;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class BirdCallSound
extends MovingSound {
    private static final int OUT_OF_RANGE_GRACE_TICKS = 20;
    private static final float STOP_HYSTERESIS = 4.0f;
    private final ClientBird bird;
    private final World world;
    private final long birdId;
    private final float baseVolume;
    private final float basePitch;
    private final float maxDist;
    private final float fadeStart;
    private final float fadePower;
    private float thicknessTarget = 0.0f;
    private float thicknessSmooth = 0.0f;
    private float underwaterTarget = 0.0f;
    private float underwaterSmoothVal = 0.0f;
    private int lastEchoTick = Integer.MIN_VALUE;
    private int occlusionTick = 0;
    private float occlusionTarget = 0.0f;
    private float occlusionSmooth = 0.0f;
    private int outOfRangeTicks = 0;

    public BirdCallSound(ClientBird bird, World world, SoundEvent event, float volume, float pitch, float maxDist, float fadeStart, float fadePower) {
        super(event, SoundCategory.AMBIENT);
        this.bird = bird;
        this.world = world;
        this.birdId = bird.getId();
        this.baseVolume = volume;
        this.basePitch = pitch;
        this.maxDist = maxDist;
        this.fadeStart = fadeStart;
        this.fadePower = fadePower;
        this.field_147659_g = false;
        this.field_147665_h = 0;
        this.field_147666_i = ISound.AttenuationType.NONE;
        this.field_147660_d = (float)bird.pos.field_72450_a;
        this.field_147661_e = (float)bird.pos.field_72448_b;
        this.field_147658_f = (float)bird.pos.field_72449_c;
        this.field_147663_c = this.basePitch;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc != null && mc.field_71439_g != null) {
            double px = mc.field_71439_g.field_70165_t;
            double py = mc.field_71439_g.field_70163_u + (double)mc.field_71439_g.func_70047_e();
            double pz = mc.field_71439_g.field_70161_v;
            double dx = (double)this.field_147660_d - px;
            double dy = (double)this.field_147661_e - py;
            double dz = (double)this.field_147658_f - pz;
            float d = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
            float gain = this.computeGainFromDistance(d);
            this.field_147662_b = this.baseVolume * gain;
        } else {
            this.field_147662_b = this.baseVolume;
        }
    }

    private float computeGainFromDistance(float d) {
        float gain;
        float md = Math.max(0.001f, this.maxDist);
        float fs = Math.max(0.0f, Math.min(this.fadeStart, md));
        if (d <= fs) {
            gain = 1.0f;
        } else {
            float denom = Math.max(0.001f, md - fs);
            float t = (d - fs) / denom;
            if (t < 0.0f) {
                t = 0.0f;
            }
            if (t > 1.0f) {
                t = 1.0f;
            }
            float oneMinus = 1.0f - t;
            gain = (float)Math.pow(oneMinus, Math.max(0.01f, this.fadePower));
        }
        gain *= gain;
        return gain;
    }

    private static float distanceToPlayer(EntityPlayer player, Vec3d soundPos) {
        double px = player.field_70165_t;
        double py = player.field_70163_u + (double)player.func_70047_e();
        double pz = player.field_70161_v;
        double dx = px - soundPos.field_72450_a;
        double dy = py - soundPos.field_72448_b;
        double dz = pz - soundPos.field_72449_c;
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public void func_73660_a() {
        float floor;
        float thickGain;
        float gain;
        float md;
        float fs;
        if (this.bird == null || this.world == null || this.bird.pos == null) {
            this.field_147668_j = true;
            return;
        }
        float bx = (float)this.bird.pos.field_72450_a;
        float by = (float)this.bird.pos.field_72448_b;
        float bz = (float)this.bird.pos.field_72449_c;
        this.field_147660_d = bx;
        this.field_147661_e = by;
        this.field_147658_f = bz;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71439_g == null) {
            this.field_147662_b = this.baseVolume;
            this.field_147663_c = this.basePitch;
            return;
        }
        double px = mc.field_71439_g.field_70165_t;
        double py = mc.field_71439_g.field_70163_u + (double)mc.field_71439_g.func_70047_e();
        double pz = mc.field_71439_g.field_70161_v;
        float underwaterGainMul = 1.0f;
        float underwaterPitchMul = 1.0f;
        if (BirdConfig.underwaterMuffleEnabled) {
            BlockPos eyePosA = new BlockPos(px, py, pz);
            BlockPos eyePosB = new BlockPos(px, py - 0.25, pz);
            boolean eyesInWater = this.world.func_180495_p(eyePosA).func_185904_a() == Material.field_151586_h || this.world.func_180495_p(eyePosB).func_185904_a() == Material.field_151586_h;
            this.underwaterTarget = eyesInWater ? 1.0f : 0.0f;
            this.underwaterSmoothVal = BirdCallSound.lerp(this.underwaterSmoothVal, this.underwaterTarget, (float)BirdConfig.underwaterSmooth);
            underwaterGainMul = BirdCallSound.lerp(1.0f, (float)BirdConfig.underwaterGain, this.underwaterSmoothVal);
            underwaterPitchMul = BirdCallSound.lerp(1.0f, (float)BirdConfig.underwaterPitchMul, this.underwaterSmoothVal);
        }
        double dx = (double)bx - px;
        double dy = (double)by - py;
        double dz = (double)bz - pz;
        double d2 = dx * dx + dy * dy + dz * dz;
        float d = (float)Math.sqrt(d2);
        double min = 2.0;
        if (d2 < min * min && d2 > 1.0E-6) {
            double dist = Math.sqrt(d2);
            double k = min / dist;
            this.field_147660_d = (float)(px + dx * k);
            this.field_147661_e = (float)(py + dy * k);
            this.field_147658_f = (float)(pz + dz * k);
        }
        if (d <= (fs = Math.max(0.0f, Math.min(this.fadeStart, md = Math.max(0.001f, this.maxDist))))) {
            gain = 1.0f;
        } else {
            float denom = Math.max(0.001f, md - fs);
            float t = (d - fs) / denom;
            if (t < 0.0f) {
                t = 0.0f;
            }
            if (t > 1.0f) {
                t = 1.0f;
            }
            float oneMinus = 1.0f - t;
            gain = (float)Math.pow(oneMinus, Math.max(0.01f, this.fadePower));
        }
        if (gain > 0.02f) {
            int interval = Math.max(1, BirdConfig.occlusionCheckIntervalTicks);
            if (this.occlusionTick++ % interval == 0) {
                Vec3d listener = new Vec3d(px, py, pz);
                Vec3d source = new Vec3d((double)bx, (double)by, (double)bz);
                OcclusionInfo info = this.computeOcclusionThickness(this.world, listener, source);
                this.occlusionTarget = info.blockedFraction;
                this.thicknessTarget = info.thicknessBlocks;
            }
            float smooth = (float)BirdConfig.occlusionSmooth;
            this.occlusionSmooth = BirdCallSound.lerp(this.occlusionSmooth, this.occlusionTarget, smooth);
            this.thicknessSmooth = BirdCallSound.lerp(this.thicknessSmooth, this.thicknessTarget, smooth);
        } else {
            this.occlusionSmooth = BirdCallSound.lerp(this.occlusionSmooth, 0.0f, 0.05f);
            this.thicknessSmooth = BirdCallSound.lerp(this.thicknessSmooth, 0.0f, 0.05f);
        }
        float k = (float)BirdConfig.occlusionThicknessK;
        float maxT = (float)BirdConfig.occlusionThicknessMax;
        float t = this.thicknessSmooth;
        if (t < 0.0f) {
            t = 0.0f;
        }
        if (t > maxT) {
            t = maxT;
        }
        if ((thickGain = (float)Math.exp(-k * t)) < (floor = (float)BirdConfig.occludedGain)) {
            thickGain = floor;
        }
        float occGain = this.occlusionSmooth <= 0.05f ? 1.0f : thickGain;
        this.field_147662_b = this.baseVolume * gain * occGain * underwaterGainMul;
        this.field_147663_c = this.basePitch * BirdCallSound.lerp(1.0f, 0.96f, Math.min(1.0f, this.thicknessSmooth / 12.0f)) * underwaterPitchMul;
        if (BirdConfig.echoEnabled && this.world != null) {
            int cd;
            boolean indoors;
            int nowTick = (int)this.world.func_82737_E();
            boolean heavilyOccluded = this.occlusionSmooth > 0.65f && this.thicknessSmooth >= (float)BirdConfig.echoMinThickness;
            BlockPos playerPos = new BlockPos(px, py, pz);
            boolean bl = indoors = !this.world.func_175678_i(playerPos);
            if ((heavilyOccluded || indoors && this.occlusionSmooth > 0.45f) && nowTick - this.lastEchoTick >= (cd = Math.max(0, BirdConfig.echoCooldownTicks))) {
                this.lastEchoTick = nowTick;
                float eVol = (float)((double)this.field_147662_b * BirdConfig.echoVolume);
                float ePit = (float)((double)this.field_147663_c * BirdConfig.echoPitchMul);
                PositionedSoundRecord echo = new PositionedSoundRecord(this.func_147650_b(), SoundCategory.AMBIENT, eVol, ePit, false, 0, ISound.AttenuationType.LINEAR, (float)px, (float)py, (float)pz);
                BirdSoundSystem.schedulePlay((ISound)echo, BirdConfig.echoDelayTicks);
            }
        }
        if (d > md + 4.0f) {
            ++this.outOfRangeTicks;
            if (this.outOfRangeTicks >= 20) {
                this.field_147668_j = true;
            }
        } else {
            this.outOfRangeTicks = 0;
        }
    }

    private static float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    private OcclusionInfo computeOcclusionThickness(World world, Vec3d listener, Vec3d source) {
        float frac;
        Vec3d dir = source.func_178788_d(listener);
        double dist = dir.func_72433_c();
        if (dist < 0.001) {
            return new OcclusionInfo(0.0f, 0.0f);
        }
        dir = dir.func_186678_a(1.0 / dist);
        float step = (float)Math.max(0.25, Math.min(2.0, BirdConfig.occlusionSampleStep));
        float maxT = (float)Math.max(1.0, Math.min(256.0, BirdConfig.occlusionThicknessMax));
        int total = 0;
        int blocked = 0;
        float thickness = 0.0f;
        float t = 1.0f;
        while ((double)t < dist && !(thickness >= maxT)) {
            Vec3d p = listener.func_178787_e(dir.func_186678_a((double)t));
            BlockPos bp = new BlockPos(p);
            IBlockState st = world.func_180495_p(bp);
            ++total;
            if (this.countsAsOccluder(st)) {
                ++blocked;
                thickness += step;
            }
            t += step;
        }
        float f = frac = total <= 0 ? 0.0f : (float)blocked / (float)total;
        if (thickness > maxT) {
            thickness = maxT;
        }
        return new OcclusionInfo(frac, thickness);
    }

    private boolean countsAsOccluder(IBlockState st) {
        if (st == null) {
            return false;
        }
        Material m = st.func_185904_a();
        if (m == null) {
            return false;
        }
        if (m == Material.field_151585_k || m == Material.field_151582_l || m == Material.field_151584_j || m == Material.field_151569_G) {
            return false;
        }
        if (m.func_76224_d()) {
            return false;
        }
        return m.func_76230_c();
    }

    public long getBirdId() {
        return this.birdId;
    }

    private float computeOcclusion(World world, Vec3d listener, Vec3d source) {
        Vec3d[] targets = new Vec3d[]{source, source.func_72441_c(0.0, 1.0, 0.0), source.func_72441_c(0.0, -1.0, 0.0), source.func_72441_c(0.8, 0.0, 0.0), source.func_72441_c(-0.8, 0.0, 0.0)};
        int blocked = 0;
        for (Vec3d t : targets) {
            RayTraceResult hit = world.func_147447_a(listener, t, false, true, false);
            if (hit == null || hit.field_72313_a != RayTraceResult.Type.BLOCK) continue;
            ++blocked;
        }
        return (float)blocked / (float)targets.length;
    }

    private static class OcclusionInfo {
        final float blockedFraction;
        final float thicknessBlocks;

        OcclusionInfo(float blockedFraction, float thicknessBlocks) {
            this.blockedFraction = blockedFraction;
            this.thicknessBlocks = thicknessBlocks;
        }
    }
}

