/*
 * Decompiled with CFR 0.152.
 */
package com.jubitus.birds.client.sound;

import com.jubitus.birds.JubitusBirds;
import com.jubitus.birds.client.sound.BirdCallSound;
import com.jubitus.birds.client.sound.BirdCallType;
import com.jubitus.birds.client.sound.ConfigSoundsResourcePack;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;

public class BirdSoundSystem {
    private static final ConcurrentHashMap<ResourceLocation, SoundEvent> EVENT_CACHE = new ConcurrentHashMap();
    private static final int DEFAULT_ATTENUATION_DISTANCE = 128;
    private static final Map<String, SpeciesPools> SPECIES_SOUNDS = new LinkedHashMap<String, SpeciesPools>();
    private static final Map<Long, ActiveEntry> ACTIVE_BY_BIRD = new ConcurrentHashMap<Long, ActiveEntry>();
    private static final int STARTUP_GRACE_TICKS = 5;
    private static final int FLOCK_SPACING_TICKS = 8;
    private static final Map<Long, Integer> LAST_FLOCK_START_TICK = new ConcurrentHashMap<Long, Integer>();
    private static final Map<String, EnumMap<BirdCallType, Integer>> ATTENUATION_BY_SPECIES = new ConcurrentHashMap<String, EnumMap<BirdCallType, Integer>>();
    private static final Queue<DelayedPlay> DELAYED = new ConcurrentLinkedQueue<DelayedPlay>();
    private static int lastTick = -1;
    private static int startedThisTick = 0;
    private static IResourcePack installedPack = null;

    private BirdSoundSystem() {
    }

    public static SoundEvent getOrCreateEvent(ResourceLocation rl) {
        return EVENT_CACHE.computeIfAbsent(rl, SoundEvent::new);
    }

    public static void installResourcePackOnce() {
        if (installedPack != null) {
            return;
        }
        installedPack = new ConfigSoundsResourcePack();
        BirdSoundSystem.injectPackIntoMinecraft(installedPack);
        Minecraft mc = Minecraft.func_71410_x();
        try {
            mc.func_110436_a();
        }
        catch (Exception e) {
            JubitusBirds.LOGGER.error("[JubitusBirds] refreshResources failed after pack install", (Throwable)e);
        }
        JubitusBirds.LOGGER.info("[JubitusBirds] Installed ConfigSoundsResourcePack for config-based .ogg sounds.");
    }

    private static void injectPackIntoMinecraft(IResourcePack pack) {
        Minecraft mc = Minecraft.func_71410_x();
        Field f = null;
        try {
            f = Minecraft.class.getDeclaredField("defaultResourcePacks");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        try {
            if (f == null) {
                f = Minecraft.class.getDeclaredField("field_110449_ao");
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (f == null) {
            JubitusBirds.LOGGER.error("[JubitusBirds] Could not find Minecraft.defaultResourcePacks field (dev or SRG). Sounds pack not installed.");
            return;
        }
        try {
            f.setAccessible(true);
            List list = (List)f.get(mc);
            if (!list.contains(pack)) {
                list.add(pack);
                JubitusBirds.LOGGER.info("[JubitusBirds] Injected ConfigSoundsResourcePack into defaultResourcePacks (size now {}).", (Object)list.size());
            }
        }
        catch (Throwable t) {
            JubitusBirds.LOGGER.error("[JubitusBirds] Failed to inject ConfigSoundsResourcePack. Sounds will not work.", t);
        }
    }

    public static void setSpeciesSounds(String soundKey, List<String> soundNamesNoExt) {
        BirdSoundSystem.setSpeciesSounds(soundKey, BirdCallType.SINGLE, soundNamesNoExt);
    }

    public static void setSpeciesSounds(String soundKey, BirdCallType type, List<String> soundNamesNoExt) {
        String key = BirdSoundSystem.safe(soundKey);
        if (soundNamesNoExt == null) {
            soundNamesNoExt = Collections.emptyList();
        }
        SpeciesPools pools = SPECIES_SOUNDS.computeIfAbsent(key, k -> new SpeciesPools());
        if (type == BirdCallType.FLOCK) {
            pools.flock = new ArrayList<String>(soundNamesNoExt);
        } else {
            pools.single = new ArrayList<String>(soundNamesNoExt);
        }
    }

    private static String safe(String s) {
        if (s == null) {
            return "unknown";
        }
        return s.toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9_\\-]", "_");
    }

    public static void clearAllSpeciesSounds() {
        SPECIES_SOUNDS.clear();
    }

    public static String buildSoundsJson() {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        boolean firstEvent = true;
        for (Map.Entry<String, SpeciesPools> e : SPECIES_SOUNDS.entrySet()) {
            String speciesKey = e.getKey();
            SpeciesPools pools = e.getValue();
            if (pools == null) continue;
            if (pools.single != null && !pools.single.isEmpty()) {
                if (!firstEvent) {
                    sb.append(",\n");
                }
                firstEvent = false;
                BirdSoundSystem.appendEvent(sb, speciesKey, BirdCallType.SINGLE, pools.single);
            }
            if (pools.flock == null || pools.flock.isEmpty()) continue;
            if (!firstEvent) {
                sb.append(",\n");
            }
            firstEvent = false;
            BirdSoundSystem.appendEvent(sb, speciesKey, BirdCallType.FLOCK, pools.flock);
        }
        sb.append("\n}\n");
        return sb.toString();
    }

    private static void appendEvent(StringBuilder sb, String speciesKey, BirdCallType type, List<String> sounds) {
        String eventKey = "default_species." + speciesKey + "." + type.eventSuffix;
        int attenuation = BirdSoundSystem.getAttenuationDistance(speciesKey, type);
        sb.append("  \"").append(eventKey).append("\": {\n");
        sb.append("    \"category\": \"ambient\",\n");
        sb.append("    \"sounds\": [\n");
        for (int i = 0; i < sounds.size(); ++i) {
            String soundNoExt = sounds.get(i);
            sb.append("      {\n");
            sb.append("        \"name\": \"").append("jubitusbirds").append(":default_species/").append(speciesKey).append("/").append(type.soundsSubdir).append("/").append(soundNoExt).append("\",\n");
            sb.append("        \"attenuation_distance\": ").append(attenuation).append("\n");
            sb.append("      }");
            if (i < sounds.size() - 1) {
                sb.append(",");
            }
            sb.append("\n");
        }
        sb.append("    ]\n");
        sb.append("  }");
    }

    private static int getAttenuationDistance(String soundKey, BirdCallType type) {
        EnumMap<BirdCallType, Integer> m = ATTENUATION_BY_SPECIES.get(BirdSoundSystem.safe(soundKey));
        if (m == null) {
            return 128;
        }
        Integer v = m.get((Object)type);
        return v != null ? v : 128;
    }

    public static boolean hasSounds(String soundKey, BirdCallType type) {
        SpeciesPools pools = SPECIES_SOUNDS.get(BirdSoundSystem.safe(soundKey));
        if (pools == null) {
            return false;
        }
        List<String> l = type == BirdCallType.FLOCK ? pools.flock : pools.single;
        return l != null && !l.isEmpty();
    }

    public static ResourceLocation getCallEvent(String soundKey, BirdCallType type) {
        return new ResourceLocation("jubitusbirds", "default_species." + BirdSoundSystem.safe(soundKey) + "." + type.eventSuffix);
    }

    public static Set<String> getAllSpeciesKeys() {
        return new LinkedHashSet<String>(SPECIES_SOUNDS.keySet());
    }

    public static List<String> getSoundsForSpecies(String soundKey, BirdCallType type) {
        SpeciesPools pools = SPECIES_SOUNDS.get(BirdSoundSystem.safe(soundKey));
        if (pools == null) {
            return Collections.emptyList();
        }
        List<String> l = type == BirdCallType.FLOCK ? pools.flock : pools.single;
        return l != null ? l : Collections.emptyList();
    }

    public static void playCallIfAllowed(long birdId, long flockId, BirdCallType type, BirdCallSound sound) {
        Integer last;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71441_e == null || mc.func_147118_V() == null) {
            return;
        }
        SoundHandler sh = mc.func_147118_V();
        int tick = (int)mc.field_71441_e.func_82737_E();
        if (tick != lastTick) {
            lastTick = tick;
            startedThisTick = 0;
        }
        if (startedThisTick >= 20) {
            return;
        }
        if (type == BirdCallType.FLOCK && flockId != 0L && (last = LAST_FLOCK_START_TICK.get(flockId)) != null && tick - last < 8) {
            return;
        }
        ActiveEntry entry = ACTIVE_BY_BIRD.get(birdId);
        if (entry != null) {
            BirdCallSound cur = entry.sound;
            if (sh.func_147692_c((ISound)cur)) {
                return;
            }
            if (tick - entry.startTick < 5 && !cur.func_147667_k()) {
                return;
            }
            BirdSoundSystem.stopForBird(birdId);
        }
        ++startedThisTick;
        ACTIVE_BY_BIRD.put(birdId, new ActiveEntry(sound, tick));
        JubitusBirds.LOGGER.info("[JubitusBirds] PLAY request bird={} flock={} type={} event={}", (Object)birdId, (Object)flockId, (Object)type, (Object)sound.func_147650_b());
        sh.func_147682_a((ISound)sound);
        if (type == BirdCallType.FLOCK && flockId != 0L) {
            LAST_FLOCK_START_TICK.put(flockId, tick);
        }
        JubitusBirds.LOGGER.info("[JubitusBirds] PLAY called; isSoundPlayingNow={}", (Object)sh.func_147692_c((ISound)sound));
    }

    public static void stopForBird(long birdId) {
        Minecraft mc = Minecraft.func_71410_x();
        SoundHandler sh = mc != null ? mc.func_147118_V() : null;
        ActiveEntry old = ACTIVE_BY_BIRD.remove(birdId);
        if (old != null && sh != null) {
            sh.func_147683_b((ISound)old.sound);
        }
    }

    public static void stopAll() {
        Minecraft mc = Minecraft.func_71410_x();
        SoundHandler sh = mc != null ? mc.func_147118_V() : null;
        for (ActiveEntry e : ACTIVE_BY_BIRD.values()) {
            if (sh == null || e == null) continue;
            sh.func_147683_b((ISound)e.sound);
        }
        ACTIVE_BY_BIRD.clear();
    }

    public static void tickCleanup() {
        int tick;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.func_147118_V() == null) {
            return;
        }
        SoundHandler sh = mc.func_147118_V();
        Iterator<Map.Entry<Long, ActiveEntry>> it = ACTIVE_BY_BIRD.entrySet().iterator();
        while (it.hasNext()) {
            DelayedPlay dp;
            ActiveEntry e2 = it.next().getValue();
            if (e2 == null || e2.sound == null) {
                it.remove();
                continue;
            }
            BirdCallSound s = e2.sound;
            boolean playing = sh.func_147692_c((ISound)s);
            if (!playing) {
                int tick2;
                int n = tick2 = mc.field_71441_e != null ? (int)mc.field_71441_e.func_82737_E() : 0;
                if (tick2 - e2.startTick < 5 && !s.func_147667_k()) continue;
                JubitusBirds.LOGGER.warn("[JubitusBirds] SOUND NOT PLAYING (rejected/ended) bird={} event={}", (Object)s.getBirdId(), (Object)s.func_147650_b());
                it.remove();
                continue;
            }
            if (s.func_147667_k()) {
                JubitusBirds.LOGGER.info("[JubitusBirds] SOUND DONE bird={} event={}", (Object)s.getBirdId(), (Object)s.func_147650_b());
                it.remove();
            }
            if (mc == null || mc.field_71441_e == null || sh == null) continue;
            int tickNow = (int)mc.field_71441_e.func_82737_E();
            while ((dp = DELAYED.peek()) != null && dp.playTick <= tickNow) {
                DELAYED.poll();
                if (dp.sound == null) continue;
                sh.func_147682_a(dp.sound);
            }
        }
        int n = tick = mc.field_71441_e != null ? (int)mc.field_71441_e.func_82737_E() : 0;
        if (tick % 200 == 0 && LAST_FLOCK_START_TICK.size() > 256) {
            int MAX_AGE = 2400;
            LAST_FLOCK_START_TICK.entrySet().removeIf(e -> tick - (Integer)e.getValue() > 2400);
        }
    }

    public static void setAttenuationDistance(String soundKey, BirdCallType type, double dist) {
        String key = BirdSoundSystem.safe(soundKey);
        int d = (int)Math.round(Math.max(4.0, Math.min(1024.0, dist)));
        ATTENUATION_BY_SPECIES.computeIfAbsent(key, k -> new EnumMap(BirdCallType.class)).put(type, d);
    }

    public static void reloadSoundsOnly() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.func_147118_V() == null || mc.func_110442_L() == null) {
            return;
        }
        mc.func_147118_V().func_110549_a(mc.func_110442_L());
        JubitusBirds.LOGGER.info("[JubitusBirds] Reloaded sound system only (no full resource refresh).");
    }

    public static void schedulePlay(ISound sound, int delayTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71441_e == null) {
            return;
        }
        int now = (int)mc.field_71441_e.func_82737_E();
        DELAYED.add(new DelayedPlay(sound, now + Math.max(0, delayTicks)));
    }

    private static class DelayedPlay {
        final ISound sound;
        final int playTick;

        DelayedPlay(ISound sound, int playTick) {
            this.sound = sound;
            this.playTick = playTick;
        }
    }

    private static class SpeciesPools {
        List<String> single = Collections.emptyList();
        List<String> flock = Collections.emptyList();

        private SpeciesPools() {
        }
    }

    private static class ActiveEntry {
        final BirdCallSound sound;
        final int startTick;

        ActiveEntry(BirdCallSound sound, int startTick) {
            this.sound = sound;
            this.startTick = startTick;
        }
    }
}

