/*
 * Decompiled with CFR 0.152.
 */
package com.jubitus.birds.client.sound;

import com.jubitus.birds.JubitusBirds;
import com.jubitus.birds.client.sound.BirdSoundSystem;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.ResourceLocation;

public class ConfigSoundsResourcePack
implements IResourcePack {
    private final Set<String> domains = Collections.singleton("jubitusbirds");

    private static String detectOggCodec(Path file) {
        try {
            int n;
            if (!Files.isRegularFile(file, new LinkOption[0])) {
                return "not_a_file";
            }
            long size = Files.size(file);
            if (size < 64L) {
                return "too_small";
            }
            byte[] buf = new byte[4096];
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file.toFile()));){
                n = ((InputStream)in).read(buf);
            }
            if (n <= 0) {
                return "unreadable";
            }
            if (buf[0] != 79 || buf[1] != 103 || buf[2] != 103 || buf[3] != 83) {
                return "not_ogg_container";
            }
            String s = new String(buf, 0, n, StandardCharsets.ISO_8859_1);
            if (s.contains("vorbis")) {
                return "vorbis";
            }
            if (s.contains("OpusHead")) {
                return "opus";
            }
            if (s.contains("Speex")) {
                return "speex";
            }
            if (s.contains("FLAC")) {
                return "flac_in_ogg";
            }
            return "unknown_ogg_codec";
        }
        catch (Exception e) {
            return "error:" + e.getClass().getSimpleName();
        }
    }

    public InputStream func_110590_a(ResourceLocation location) throws IOException {
        if ("pack.mcmeta".equals(location.func_110623_a())) {
            String mcmeta = "{ \"pack\": { \"pack_format\": 3, \"description\": \"JubitusBirds Config Sounds\" } }";
            return new ByteArrayInputStream(mcmeta.getBytes(StandardCharsets.UTF_8));
        }
        if ("sounds.json".equals(location.func_110623_a())) {
            String json = BirdSoundSystem.buildSoundsJson();
            return new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
        }
        String p = location.func_110623_a();
        if (p.startsWith("sounds/default_species/") && p.endsWith(".ogg")) {
            long size;
            Path file = this.mapToConfigOgg(p);
            if (file == null) {
                JubitusBirds.LOGGER.warn("[JubitusBirds] mapToConfigOgg returned null for {}", (Object)p);
                throw new FileNotFoundException(location.toString());
            }
            if (!Files.exists(file, new LinkOption[0])) {
                JubitusBirds.LOGGER.warn("[JubitusBirds] Sound file NOT FOUND for {} -> {}", (Object)p, (Object)file.toAbsolutePath());
                throw new FileNotFoundException(location.toString());
            }
            try {
                size = Files.size(file);
            }
            catch (IOException e) {
                JubitusBirds.LOGGER.warn("[JubitusBirds] Could not stat size for sound {} -> {}", (Object)p, (Object)file.toAbsolutePath(), (Object)e);
                size = -1L;
            }
            JubitusBirds.LOGGER.info("[JubitusBirds] Serving sound {} -> {} ({} bytes)", (Object)p, (Object)file.toAbsolutePath(), (Object)size);
            return new BufferedInputStream(new FileInputStream(file.toFile()));
        }
        throw new FileNotFoundException(location.toString());
    }

    public boolean func_110589_b(ResourceLocation location) {
        if ("pack.mcmeta".equals(location.func_110623_a())) {
            return true;
        }
        if ("sounds.json".equals(location.func_110623_a())) {
            return true;
        }
        String p = location.func_110623_a();
        if (p.startsWith("sounds/default_species/") && p.endsWith(".ogg")) {
            Path file = this.mapToConfigOgg(p);
            return file != null && Files.exists(file, new LinkOption[0]);
        }
        return false;
    }

    public Set<String> func_110587_b() {
        return this.domains;
    }

    public <T extends IMetadataSection> T func_135058_a(MetadataSerializer serializer, String metadataSectionName) {
        return null;
    }

    public BufferedImage func_110586_a() {
        return null;
    }

    public String func_130077_b() {
        return "JubitusBirds Config Sounds";
    }

    private Path mapToConfigOgg(String resourcePath) {
        String fileName;
        String rest = resourcePath.substring("sounds/default_species/".length());
        String[] parts = rest.split("/");
        if (parts.length < 2) {
            return null;
        }
        String speciesKey = parts[0];
        String typePart = null;
        if (parts.length >= 3) {
            typePart = parts[1];
            fileName = parts[2];
        } else {
            fileName = parts[1];
        }
        File gameDir = Minecraft.func_71410_x().field_71412_D;
        Path speciesBase = gameDir.toPath().resolve("config").resolve("jubitusbirds").resolve("default_species").resolve(speciesKey);
        if ("single".equals(typePart)) {
            return speciesBase.resolve("sounds_single").resolve(fileName);
        }
        if ("flock".equals(typePart)) {
            return speciesBase.resolve("sounds_flock").resolve(fileName);
        }
        return speciesBase.resolve("sounds").resolve(fileName);
    }
}

